/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.ServerCommandException;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarvestServiceImpl
extends AbstractService
implements HarvestService {
    public static final String HARVEST_THREAD_NAME = "New Relic Harvest Service";
    private static final int MAX_DATA_CONNECTION_ERRORS_TO_LOG = 5;
    private static final long INITIAL_DELAY = 30000L;
    private static final long MIN_HARVEST_INTERVAL_IN_NANOSECONDS = TimeUnit.NANOSECONDS.convert(55L, TimeUnit.SECONDS);
    private static final long REPORTING_PERIOD_IN_MILLISECONDS = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final ScheduledExecutorService scheduledExecutor;
    private final List<HarvestListener> harvestListeners = new CopyOnWriteArrayList<HarvestListener>();
    private final Map<IRPMService, HarvestTask> harvestTasks = new HashMap<IRPMService, HarvestTask>();

    public HarvestServiceImpl() {
        super(HarvestService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(HARVEST_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ServiceFactory.getRPMServiceManager().addConnectionListener(new ConnectionListenerImpl());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    public void startHarvest(IRPMService rpmService) {
        HarvestTask harvestTask = this.getOrCreateHarvestTask(rpmService);
        harvestTask.start();
    }

    private synchronized HarvestTask getOrCreateHarvestTask(IRPMService rpmService) {
        HarvestTask harvestTask = this.harvestTasks.get(rpmService);
        if (harvestTask == null) {
            harvestTask = new HarvestTask(rpmService);
            this.harvestTasks.put(rpmService, harvestTask);
        }
        return harvestTask;
    }

    private synchronized List<HarvestTask> getHarvestTasks() {
        return new ArrayList<HarvestTask>(this.harvestTasks.values());
    }

    @Override
    public void addHarvestListener(HarvestListener listener) {
        this.harvestListeners.add(listener);
    }

    @Override
    public void removeHarvestListener(HarvestListener listener) {
        this.harvestListeners.remove(listener);
    }

    @Override
    protected void doStop() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            task.stop();
        }
        this.scheduledExecutor.shutdown();
    }

    private ScheduledFuture<?> scheduleHarvestTask(HarvestTask harvestTask) {
        return this.scheduledExecutor.scheduleAtFixedRate(harvestTask, this.getInitialDelay(), this.getReportingPeriod(), TimeUnit.MILLISECONDS);
    }

    public long getInitialDelay() {
        return 30000L;
    }

    public long getReportingPeriod() {
        return REPORTING_PERIOD_IN_MILLISECONDS;
    }

    public long getMinHarvestInterval() {
        return MIN_HARVEST_INTERVAL_IN_NANOSECONDS;
    }

    @Override
    public void harvestNow() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            task.harvestNow();
        }
    }

    private void reportHarvest(String appName, StatsEngine statsEngine, IRPMService rpmService) {
        try {
            rpmService.harvest(statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error reporting harvest data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private void notifyListenerBeforeHarvest(String appName, StatsEngine statsEngine, HarvestListener listener) {
        try {
            listener.beforeHarvest(appName, statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error harvesting data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private void notifyListenerAfterHarvest(String appName, HarvestListener listener) {
        try {
            listener.afterHarvest(appName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error harvesting data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connected(IRPMService rpmService, Map<String, Object> connectionInfo) {
            HarvestServiceImpl.this.startHarvest(rpmService);
        }

        @Override
        public void disconnected(IRPMService rpmService) {
        }
    }

    private final class HarvestTask
    implements Runnable {
        private final IRPMService rpmService;
        private ScheduledFuture<?> task;
        private int errorCount = 0;
        private final Lock harvestLock = new ReentrantLock();
        private StatsEngine lastStatsEngine = new StatsEngineImpl();
        private long lastHarvestStartTime;

        private HarvestTask(IRPMService rpmService) {
            this.rpmService = rpmService;
        }

        public void run() {
            try {
                if (this.shouldHarvest()) {
                    this.harvest();
                }
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("Unexpected exception during harvest: {0}", t);
                if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                    HarvestServiceImpl.this.getLogger().log(Level.WARNING, msg, t);
                }
                HarvestServiceImpl.this.getLogger().warning(msg);
            }
        }

        private boolean shouldHarvest() {
            return System.nanoTime() - this.lastHarvestStartTime >= HarvestServiceImpl.this.getMinHarvestInterval();
        }

        private synchronized void start() {
            if (!this.isRunning()) {
                this.stop();
                String msg = MessageFormat.format("Scheduling harvest task for {0}", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().log(Level.FINE, msg);
                this.task = HarvestServiceImpl.this.scheduleHarvestTask(this);
            }
        }

        private synchronized void stop() {
            if (this.task != null) {
                HarvestServiceImpl.this.getLogger().fine(MessageFormat.format("Cancelling harvest task for {0}", this.rpmService.getApplicationName()));
                this.task.cancel(false);
            }
        }

        private boolean isRunning() {
            if (this.task == null) {
                return false;
            }
            return !this.task.isCancelled() || this.task.isDone();
        }

        private void harvestNow() {
            if (this.rpmService.isConnected() && this.harvestLock.tryLock()) {
                String msg = MessageFormat.format("Sending metrics for {0} immediately", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().info(msg);
                this.harvest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void harvest() {
            this.harvestLock.lock();
            try {
                this.doHarvest();
                this.errorCount = 0;
            }
            catch (ServerCommandException e) {
            }
            catch (IgnoreSilentlyException e) {
            }
            catch (Throwable e) {
                String msg;
                ++this.errorCount;
                if (this.errorCount <= 5) {
                    msg = MessageFormat.format("Error sending metric data for {0}: {1}", this.rpmService.getApplicationName(), e.toString());
                    if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                        HarvestServiceImpl.this.getLogger().log(Level.FINER, msg, e);
                    } else {
                        HarvestServiceImpl.this.getLogger().info(msg);
                    }
                }
                if (this.errorCount == 5) {
                    msg = MessageFormat.format("No more data connection exceptions for {0} will be logged until after the agent connection is re-established", this.rpmService.getApplicationName());
                    HarvestServiceImpl.this.getLogger().info(msg);
                }
            }
            finally {
                this.harvestLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doHarvest() throws Exception {
            long duration;
            this.lastHarvestStartTime = System.nanoTime();
            String appName = this.rpmService.getApplicationName();
            if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Starting harvest for {0}", appName);
                HarvestServiceImpl.this.getLogger().fine(msg);
            }
            StatsEngine harvestStatsEngine = ServiceFactory.getStatsService().getStatsEngineForHarvest(appName);
            harvestStatsEngine.mergeStats(this.lastStatsEngine);
            try {
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    HarvestServiceImpl.this.notifyListenerBeforeHarvest(appName, harvestStatsEngine, listener);
                }
                HarvestServiceImpl.this.reportHarvest(appName, harvestStatsEngine, this.rpmService);
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    HarvestServiceImpl.this.notifyListenerAfterHarvest(appName, listener);
                }
                this.lastStatsEngine = harvestStatsEngine;
                duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.lastHarvestStartTime, TimeUnit.NANOSECONDS);
                harvestStatsEngine.getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration, TimeUnit.MILLISECONDS);
                if (!HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) return;
            }
            catch (Throwable throwable) {
                this.lastStatsEngine = harvestStatsEngine;
                long duration2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.lastHarvestStartTime, TimeUnit.NANOSECONDS);
                harvestStatsEngine.getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration2, TimeUnit.MILLISECONDS);
                if (!HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) throw throwable;
                String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", appName, duration2);
                HarvestServiceImpl.this.getLogger().fine(msg);
                throw throwable;
            }
            String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", appName, duration);
            HarvestServiceImpl.this.getLogger().fine(msg);
        }
    }
}

