/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentMessage;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.Environment;
import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.ForceRestartException;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.InternalLimitExceeded;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.MetricDataException;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.Hostname;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.metric.MetricIdRegistry;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.session.SessionService;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderFactory;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.validation.TokenValidation;
import com.newrelic.org.json.simple.JSONObject;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.rmi.UnexpectedException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPMService
extends AbstractService
implements IRPMService {
    public static final String COLLECT_TRACES_KEY = "collect_traces";
    public static final String COLLECT_ERRORS_KEY = "collect_errors";
    public static final String DATA_REPORT_PERIOD_KEY = "data_report_period";
    public static final String TRANSACTION_NAME_NAMING_SCHEME_KEY = "transaction_name.naming_scheme";
    public static final String SUPPORTABILITY_METRIC_HARVEST_INTERVAL = "Supportability/MetricHarvest/interval";
    public static final String SUPPORTABILITY_METRIC_HARVEST_TRANSMIT = "Supportability/MetricHarvest/transmit";
    public static final String SUPPORTABILITY_METRIC_HARVEST_COUNT = "Supportability/MetricHarvest/count";
    public static final String AGENT_METRICS_COUNT = "Agent/Metrics/Count";
    public static final int DEFAULT_REQUEST_TIMEOUT_IN_SECONDS = 120;
    public static final String FRAMEWORK_TRANSACTION_NAMING_SCHEME = "framework";
    private static final int MESSAGE_LIMIT_PER_PERIOD = 20;
    private String host;
    private int port;
    private volatile boolean connected = false;
    private final ErrorService errorService;
    private long lastReportTime;
    private final List<AgentMessage> messageQueue;
    private final SessionService sessionService;
    private Environment launchEnvironment;
    private final String appName;
    private final List<String> appNames;
    private final ConnectionListener connectionListener;
    private final boolean isMainApp;
    private volatile boolean hasEverConnected = false;
    private volatile String transactionNamingScheme;
    private final DataSender dataSender;
    private final MetricIdRegistry metricIdRegistry = new MetricIdRegistry();
    private long connectionTimestamp = 0L;
    private String applicationIdentifier;

    public RPMService(List<String> appNames, ConnectionListener connectionListener) {
        super(RPMService.class.getSimpleName() + "/" + appNames.get(0));
        this.appName = appNames.get(0).intern();
        IAgentConfig config = ServiceFactory.getConfigService().getAgentConfig(this.appName);
        this.dataSender = DataSenderFactory.create(config);
        this.appNames = appNames;
        this.connectionListener = connectionListener;
        this.messageQueue = Collections.synchronizedList(new LinkedList());
        this.lastReportTime = System.currentTimeMillis();
        this.errorService = new ErrorService(this.appName);
        this.sessionService = new SessionService();
        this.host = config.getHost();
        this.port = config.getPort();
        this.isMainApp = this.appName.equals(config.getApplicationName());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        this.connect();
    }

    private Map<String, Object> getStartOptions() {
        IAgentConfig agentConfig = ServiceFactory.getConfigService().getAgentConfig(this.appName);
        int pid = ServiceFactory.getEnvironmentService().getProcessPID();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("pid", pid);
        String language = agentConfig.getLanguage();
        options.put("language", language);
        options.put("host", Hostname.getHostname(Agent.LOG));
        Environment environment = ServiceFactory.getEnvironmentService().getEnvironment();
        try {
            this.launchEnvironment = environment.clone();
        }
        catch (CloneNotSupportedException e) {
            Agent.LOG.log(Level.FINER, "Environment clone error", e);
        }
        options.put("environment", environment);
        if (agentConfig.getProperty("send_environment_info", true).booleanValue()) {
            options.put("settings", this.getSettings());
        }
        HashMap<String, String> validationOptions = new HashMap<String, String>();
        try {
            String seed = TokenValidation.getSeed();
            Agent.LOG.finer(MessageFormat.format("Using seed {0} for token validation", seed));
            validationOptions.put("seed", seed);
        }
        catch (UnknownHostException e) {
            Agent.LOG.log(Level.WARNING, "Exception while retrieving IP address for token validation seed", e);
        }
        validationOptions.put("validate", TokenValidation.getTokenFromEnvironment());
        options.put("validate", validationOptions);
        options.put("agent_version", Agent.getVersion());
        options.put("app_name", this.appNames);
        StringBuilder identifier = new StringBuilder(language);
        identifier.append(':').append(this.appName);
        if (environment.getServerPort() != null) {
            identifier.append(':').append(environment.getServerPort());
        }
        options.put("identifier", identifier.toString());
        return options;
    }

    private Map<String, Object> getSettings() {
        String buildDate;
        Map<String, Object> localSettings = ServiceFactory.getConfigService().getSanitizedLocalSettings();
        HashMap<String, Object> settings = new HashMap<String, Object>(localSettings);
        Map<String, String> props = SystemPropertyFactory.getSystemPropertyProvider().getNewRelicSystemProperties();
        if (!props.isEmpty()) {
            settings.put("system", props);
        }
        if ((buildDate = AgentJarHelper.getBuildDate()) != null) {
            settings.put("build_date", buildDate);
        }
        settings.put("services", ServiceFactory.getServicesConfiguration());
        return settings;
    }

    @Override
    public synchronized Map<String, Object> launch() throws Exception {
        if (this.isConnected()) {
            return null;
        }
        Map<String, Object> data = null;
        try {
            data = this.dataSender.connect(this.getStartOptions());
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
        Agent.LOG.finer(MessageFormat.format("Connection response : {0}", data));
        List<String> requiredParams = Arrays.asList(COLLECT_ERRORS_KEY, COLLECT_TRACES_KEY, DATA_REPORT_PERIOD_KEY);
        if (!data.keySet().containsAll(requiredParams)) {
            throw new UnexpectedException(MessageFormat.format("Missing the following connection parameters", requiredParams.removeAll(data.keySet())));
        }
        Agent.LOG.info(MessageFormat.format("Agent {0} connected to {1}", this.toString(), this.getHostString()));
        this.transactionNamingScheme = (String)data.get(TRANSACTION_NAME_NAMING_SCHEME_KEY);
        if (this.transactionNamingScheme != null) {
            this.transactionNamingScheme = this.transactionNamingScheme.intern();
            Agent.LOG.info(MessageFormat.format("Setting: {0} to: {1}", TRANSACTION_NAME_NAMING_SCHEME_KEY, this.transactionNamingScheme));
        }
        this.applicationIdentifier = (String)data.get("account_app_id");
        this.connectionTimestamp = System.currentTimeMillis();
        this.connected = true;
        this.hasEverConnected = true;
        if (this.connectionListener != null) {
            this.connectionListener.connected(this, data);
        }
        if (!ServiceFactory.getConfigService().getAgentConfig(this.appName).isCrossProcessFeatureEnabled()) {
            this.applicationIdentifier = null;
        }
        return data;
    }

    @Override
    public String getTransactionNamingScheme() {
        return this.transactionNamingScheme;
    }

    private void logForceDisconnectException(ForceDisconnectException e) {
        String msg = MessageFormat.format("Received a ForceDisconnectException: {0}", e);
        Agent.LOG.info(msg);
    }

    private void shutdownAsync() {
        ServiceFactory.getAgent().shutdownAsync();
    }

    private void logForceRestartException(ForceRestartException e) {
        String msg = MessageFormat.format("Received a ForceRestartException: {0}", e);
        Agent.LOG.info(msg);
    }

    private void reconnectSync() throws Exception {
        this.disconnect();
        this.launch();
    }

    private void reconnectAsync() {
        this.disconnect();
        ServiceFactory.getRPMConnectionService().connectImmediate(this);
    }

    private void disconnect() {
        this.connected = false;
        this.metricIdRegistry.clear();
        this.applicationIdentifier = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reconnect() {
        Agent.LOG.info(MessageFormat.format("{0} is reconnecting", this.getApplicationName()));
        try {
            this.shutdown();
        }
        catch (Exception exception) {
        }
        finally {
            this.reconnectAsync();
        }
    }

    @Override
    public void setApplicationServerPort(Integer port) {
        Environment env = ServiceFactory.getEnvironmentService().getEnvironment();
        if (env.getServerPort() == null) {
            Agent.LOG.finer("Application server port: " + port);
            env.setServerPort(port);
            if (this.launchEnvironment != null && this.launchEnvironment.getServerPort() == null) {
                Agent.LOG.info(MessageFormat.format("The agent recognized the application server port {0} after connecting to New Relic.  Reconnecting..", String.valueOf(port)));
                this.reconnect();
            }
        } else {
            Agent.LOG.finest("Application server port already set, not changing it to port " + port);
        }
    }

    @Override
    public String getHostString() {
        return MessageFormat.format("{0}:{1}", this.host, Integer.toString(this.port));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ManagementFactory.getRuntimeMXBean().getName());
        builder.append('/').append(this.appName);
        return builder.toString();
    }

    private void sendErrorData(List<TracedError> errors) {
        Agent.LOG.fine(MessageFormat.format("Sending {0} error(s)", errors.size()));
        try {
            this.dataSender.sendErrorData(errors);
        }
        catch (IgnoreSilentlyException e) {
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error sending error data: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            }
            Agent.LOG.warning(msg);
        }
    }

    @Override
    public List<Long> sendProfileData(List<Profile> profiles) throws Exception {
        Agent.LOG.info(MessageFormat.format("Sending {0} profile(s)", profiles.size()));
        try {
            return this.sendProfileDataSyncRestart(profiles);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private List<Long> sendProfileDataSyncRestart(List<Profile> profiles) throws Exception {
        try {
            return this.dataSender.sendProfileData(profiles);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            return this.dataSender.sendProfileData(profiles);
        }
    }

    @Override
    public void sendSqlTraceData(List<SqlTrace> sqlTraces) throws Exception {
        Agent.LOG.fine(MessageFormat.format("Sending {0} sql trace(s)", sqlTraces.size()));
        try {
            this.sendSqlTraceDataSyncRestart(sqlTraces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendSqlTraceDataSyncRestart(List<SqlTrace> sqlTraces) throws Exception {
        try {
            this.dataSender.sendSqlTraceData(sqlTraces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendSqlTraceData(sqlTraces);
        }
    }

    @Override
    public void sendTransactionTraceData(List<TransactionTrace> traces) throws Exception {
        Agent.LOG.fine(MessageFormat.format("Sending {0} trace(s)", traces.size()));
        try {
            this.sendTransactionTraceDataSyncRestart(traces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendTransactionTraceDataSyncRestart(List<TransactionTrace> traces) throws Exception {
        try {
            this.dataSender.sendTransactionTraceData(traces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendTransactionTraceData(traces);
        }
    }

    @Override
    public void logAndQueueMessages(Level level, AgentMessage ... messages) {
        for (AgentMessage message : messages) {
            Agent.LOG.log(level, message.getTitle());
        }
        this.queueMessages(messages);
    }

    @Override
    public void queueMessages(AgentMessage ... messages) {
        this.messageQueue.addAll(Arrays.asList(messages));
    }

    void sendMessageData(AgentMessage ... messages) {
        if (!this.connected) {
            return;
        }
        try {
            this.dataSender.sendMessageData(Arrays.asList(RPMService.truncateMessages(messages)));
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error sending message data: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            }
            Agent.LOG.warning(msg);
        }
    }

    static AgentMessage[] truncateMessages(AgentMessage ... messages) {
        if (messages.length > 20) {
            AgentMessage[] truncatedMessages = new AgentMessage[20];
            System.arraycopy(messages, 0, truncatedMessages, 0, 20);
            return truncatedMessages;
        }
        return messages;
    }

    @Override
    public ErrorService getErrorService() {
        return this.errorService;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public boolean isMainApp() {
        return this.isMainApp;
    }

    @Override
    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws Exception {
        try {
            if (this.isConnected()) {
                this.sendMessagesFromQueue();
                this.dataSender.shutdown(System.currentTimeMillis());
            }
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public List<List<?>> getAgentCommands() throws Exception {
        try {
            return this.getAgentCommandsSyncRestart();
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private List<List<?>> getAgentCommandsSyncRestart() throws Exception {
        try {
            return this.dataSender.getAgentCommands();
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            return this.dataSender.getAgentCommands();
        }
    }

    @Override
    public void sendCommandResults(Map<Long, Object> commandResults) throws Exception {
        try {
            this.sendCommandResultsSyncRestart(commandResults);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendCommandResultsSyncRestart(Map<Long, Object> commandResults) throws Exception {
        try {
            this.dataSender.sendCommandResults(commandResults);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendCommandResults(commandResults);
        }
    }

    public void queuePingCommand() throws Exception {
        try {
            this.queuePingCommandSyncRestart();
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void queuePingCommandSyncRestart() throws Exception {
        try {
            this.dataSender.queuePingCommand();
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.queuePingCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessagesFromQueue() {
        try {
            this.sendMessageData(this.messageQueue.toArray(new AgentMessage[0]));
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINE, "Unable to send messages", e);
        }
        finally {
            this.messageQueue.clear();
        }
    }

    public void connect() {
        ServiceFactory.getRPMConnectionService().connect(this);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean hasEverConnected() {
        return this.hasEverConnected;
    }

    @Override
    public void harvest(StatsEngine statsEngine) {
        this.sessionService.beforeHarvest(this.appName, statsEngine);
        List<TracedError> errors = this.errorService.harvest(this, statsEngine);
        if (this.isConnected()) {
            long reportInterval;
            long startTime;
            List<MetricData> data;
            boolean retry;
            block13: {
                retry = false;
                if (this.metricIdRegistry.getSize() > 1000) {
                    statsEngine.getStats(AGENT_METRICS_COUNT).setCallCount(this.metricIdRegistry.getSize());
                }
                Normalizer metricNormalizer = ServiceFactory.getNormalizationService().getMetricNormalizer(this.appName);
                data = statsEngine.getMetricData(metricNormalizer, this.metricIdRegistry);
                startTime = System.nanoTime();
                reportInterval = 0L;
                try {
                    long now = System.currentTimeMillis();
                    List<List<?>> responseList = this.sendMetricDataSyncRestart(this.lastReportTime, now, data);
                    reportInterval = now - this.lastReportTime;
                    this.lastReportTime = now;
                    this.registerMetricIds(responseList);
                }
                catch (InternalLimitExceeded e) {
                    this.logMetricDataError(e);
                }
                catch (MetricDataException e) {
                    this.logMetricDataError(e);
                }
                catch (HttpError e) {
                    this.logMetricDataError(e);
                    if (e.getStatusCode() != 413) {
                        retry = true;
                    }
                }
                catch (ForceRestartException e) {
                    this.logForceRestartException(e);
                    this.reconnectAsync();
                    retry = true;
                }
                catch (ForceDisconnectException e) {
                    this.logForceDisconnectException(e);
                    this.shutdownAsync();
                }
                catch (Exception e) {
                    this.logMetricDataError(e);
                    retry = true;
                    String message = e.getMessage().toLowerCase();
                    if (!message.contains("json") || !message.contains("parse")) break block13;
                    retry = false;
                }
            }
            long duration = System.nanoTime() - startTime;
            if (!retry) {
                statsEngine.clear();
                this.recordSupportabilityMetrics(statsEngine, reportInterval, duration, data.size());
            }
            String msg = MessageFormat.format("Reported {0} timeslices for {1}", data.size(), this.getApplicationName());
            Agent.LOG.fine(msg);
            this.sendMessagesFromQueue();
            this.sendErrorData(errors);
        } else {
            if (this.messageQueue.size() > 0) {
                Agent.LOG.fine("Clearing the message queue");
            }
            this.messageQueue.clear();
        }
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long reportInterval, long duration, int dataSize) {
        if (reportInterval > 0L) {
            statsEngine.getResponseTimeStats(SUPPORTABILITY_METRIC_HARVEST_INTERVAL).recordResponseTime(reportInterval, TimeUnit.MILLISECONDS);
        }
        statsEngine.getResponseTimeStats(SUPPORTABILITY_METRIC_HARVEST_TRANSMIT).recordResponseTime(duration, TimeUnit.NANOSECONDS);
        statsEngine.getStats(SUPPORTABILITY_METRIC_HARVEST_COUNT).incrementCallCount(dataSize);
    }

    private List<List<?>> sendMetricDataSyncRestart(long beginTimeMillis, long endTimeMillis, List<MetricData> metricData) throws Exception {
        try {
            return this.dataSender.sendMetricData(beginTimeMillis, endTimeMillis, metricData);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            return this.dataSender.sendMetricData(beginTimeMillis, endTimeMillis, metricData);
        }
    }

    private void registerMetricIds(List<List<?>> responseList) {
        for (List<?> response : responseList) {
            JSONObject jsonObj = (JSONObject)JSONObject.class.cast(response.get(0));
            MetricName metricName = MetricName.parseJSON(jsonObj);
            Long id = (Long)Long.class.cast(response.get(1));
            this.metricIdRegistry.setMetricId(metricName, id.intValue());
        }
    }

    private void logMetricDataError(Exception e) {
        String msg = MessageFormat.format("Error occurred sending metric data: {0}", e);
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.WARNING, msg, e);
        } else {
            Agent.LOG.warning(msg);
        }
    }

    @Override
    protected void doStop() {
        try {
            this.shutdown();
        }
        catch (Exception e) {
            Level level = e instanceof ConnectException ? Level.FINER : Level.SEVERE;
            Agent.LOG.log(level, "An error occurred in the NewRelic agent shutdown", e);
        }
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    @Override
    public long getConnectionTimestamp() {
        return this.connectionTimestamp;
    }
}

