/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.application.PriorityApplicationName;
import com.newrelic.agent.beacon.BeaconTransactionState;
import com.newrelic.agent.beacon.BeaconTransactionStateImpl;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.database.CachingDatabaseStatementParser;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.errors.StackTraceError;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletUtils;
import com.newrelic.agent.sql.SqlTracerListener;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.WebRequestDispatcher;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.SameOrHigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionCache;
import com.newrelic.agent.transaction.TransactionNameListener;
import com.newrelic.agent.transaction.TransactionNamePriority;
import com.newrelic.agent.transaction.UnmodifiableTransactionNameException;
import com.newrelic.agent.util.StackTraces;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Transaction
implements ITransaction {
    public static final String SIZE_LIMIT_PARAMETER_NAME = "size_limit";
    private static final int INITIAL_PARAMETER_MAP_SIZE = 8;
    public static final String CPU_TIME_PARAMETER_NAME = "cpu_time";
    public static final String GC_TIME_PARAMETER_NAME = "gc_time";
    private static final ThreadLocal<Transaction> transactionHolder = new ThreadLocal<Transaction>(){

        @Override
        protected Transaction initialValue() {
            if (Thread.currentThread() instanceof ThreadService.AgentThread) {
                return null;
            }
            Transaction tx = new Transaction();
            ServiceFactory.getTransactionService().addTransaction(tx);
            return tx;
        }

        @Override
        public void remove() {
            ServiceFactory.getTransactionService().removeTransaction();
            super.remove();
        }

        @Override
        public void set(Transaction value) {
            super.set(value);
            ServiceFactory.getTransactionService().addTransaction(value);
        }
    };
    private final Collection<Tracer> tracers;
    private final Map<String, Object> parameters;
    private Map<String, Object> internalParameters;
    private final TransactionCache transactionCache;
    private final long startTime;
    private final long cpuStartTimeInNanos;
    private final long startGCTimeInMillis;
    private volatile boolean reportedStall = false;
    private boolean traceDisabled = false;
    private PriorityTransactionName priorityTransactionName = PriorityTransactionName.NONE;
    private PriorityApplicationName priorityApplicationName = PriorityApplicationName.NONE;
    private String normalizedUri;
    private Throwable throwable;
    private final TransactionStats transactionStats = new TransactionStats();
    private DatabaseStatementParser databaseStatementParser;
    private List<TransactionNameListener> transactionNameListeners;
    private String guid;
    private int tracerStartLock = 0;
    private TransactionState transactionState = new TransactionStateImpl();
    private int stackTraceCount;
    private int explainPlanCount;
    private int transactionSize = 0;
    private int responseStatus;
    private String statusMessage;
    private boolean ignore = false;
    private final IAgent agent;
    private IAgentConfig agentConfig;
    private final boolean ttEnabled;
    private final int transactionSizeLimit;
    private final int maxSegments;
    private int segmentCount = 0;
    private boolean overTracerSegmentLimit = false;
    private DispatcherTracer rootTracer;
    private Dispatcher dispatcher;
    private Tracer lastTracer;
    private final boolean autoAppNamingEnabled;
    private final boolean transactionNamingEnabled;
    private SqlTracerListener sqlTracerListener;
    private BeaconTransactionState beaconTransactionState;

    private Transaction() {
        IAgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.agent = ServiceFactory.getAgent();
        this.autoAppNamingEnabled = defaultConfig.isAutoAppNamingEnabled();
        this.maxSegments = defaultConfig.getTransactionTracerConfig().getMaxSegments();
        this.transactionNamingEnabled = this.initializeTransactionNamingEnabled(defaultConfig);
        TransactionTraceService ttService = ServiceFactory.getTransactionTraceService();
        this.ttEnabled = ttService.isEnabled();
        this.transactionSizeLimit = defaultConfig.getTransactionSizeLimit();
        this.transactionCache = new TransactionCache();
        this.tracers = this.ttEnabled ? new ArrayList(128) : null;
        this.parameters = new HashMap<String, Object>(8);
        this.startTime = System.currentTimeMillis();
        if (this.ttEnabled) {
            if (ttService.isThreadCpuTimeEnabled()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                this.cpuStartTimeInNanos = threadMXBean.getCurrentThreadCpuTime();
            } else {
                this.cpuStartTimeInNanos = 0L;
            }
            this.startGCTimeInMillis = defaultConfig.getTransactionTracerConfig().isGCTimeEnabled() ? this.getGCTime() : 0L;
        } else {
            this.startGCTimeInMillis = 0L;
            this.cpuStartTimeInNanos = 0L;
        }
    }

    private boolean initializeTransactionNamingEnabled(IAgentConfig config) {
        if (!config.isAutoTransactionNamingEnabled()) {
            return false;
        }
        IRPMService rpmService = this.getRPMService();
        if (rpmService == null) {
            return true;
        }
        String transactionNamingScheme = this.getRPMService().getTransactionNamingScheme();
        return "framework" != transactionNamingScheme;
    }

    private long getGCTime() {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTime += gcBean.getCollectionTime();
        }
        return gcTime;
    }

    public void reportAsStall(long threadId) {
        if (!this.reportedStall && !this.ignore) {
            this.reportedStall = true;
            this.reportStall(threadId, this.getRootTracer(), this.getLastTracer());
        }
    }

    private void reportStall(long executionThreadId, Tracer rootTracer, Tracer topTracer) {
        if (rootTracer == null) {
            return;
        }
        if (Agent.isDebugEnabled() || this.dispatcher.isWebTransaction()) {
            StackTraceElement[] stackTrace = StackTraces.getThreadStackTraceElements(executionThreadId);
            if (stackTrace == null || stackTrace.length == 0) {
                return;
            }
            List<StackTraceElement> stackTraces = StackTraces.scrubAndTruncate(stackTrace);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (rootTracer != null) {
                parameters.put("root_tracer_class", rootTracer.getClass().getName());
            }
            StringBuilder message = new StringBuilder("Stall");
            if (topTracer != null) {
                String metricName = topTracer.getMetricName();
                if (metricName != null) {
                    message.append(" in ").append(metricName);
                }
                parameters.put("current_tracer_class", topTracer.getClass().getName());
            }
            String requestUri = this.dispatcher.getUri();
            StackTraceError error = new StackTraceError(this.getApplicationName(), requestUri, message.toString(), "Stall", stackTraces.toArray(new StackTraceElement[0]), requestUri, parameters);
            this.getRPMService().getErrorService().reportError(error);
        }
    }

    public TransactionStats getTransactionStats() {
        return this.transactionStats;
    }

    public IAgent getAgent() {
        return this.agent;
    }

    @Override
    public IAgentConfig getAgentConfig() {
        if (this.agentConfig == null) {
            String appName = this.getApplicationName();
            this.agentConfig = ServiceFactory.getConfigService().getAgentConfig(appName);
        }
        return this.agentConfig;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object putInternalParameter(String key, Object value) {
        return this.getInternalParameters().put(key, value);
    }

    public Object getInternalParameter(String key) {
        if (this.internalParameters == null) {
            return null;
        }
        return this.getInternalParameters().get(key);
    }

    private Map<String, Object> getInternalParameters() {
        if (this.internalParameters == null) {
            this.internalParameters = new HashMap<String, Object>();
        }
        return this.internalParameters;
    }

    private void clearInternalParameters() {
        if (this.internalParameters != null) {
            this.internalParameters.clear();
        }
    }

    public ITransactionTracerConfig getTransactionTracerConfig() {
        if (this.rootTracer == null) {
            return this.getAgentConfig().getTransactionTracerConfig();
        }
        return this.rootTracer.getTransactionTracerConfig();
    }

    @Override
    public PriorityTransactionName getPriorityTransactionName() {
        return this.priorityTransactionName;
    }

    @Override
    public void freezeTransactionName() {
        if (this.priorityTransactionName.isFrozen()) {
            return;
        }
        this.dispatcher.setTransactionName();
        this.renameTransaction();
        this.priorityTransactionName = this.priorityTransactionName.freeze();
    }

    private void renameTransaction() {
        String appName = this.getApplicationName();
        Normalizer txNormalizer = ServiceFactory.getNormalizationService().getTransactionNormalizer(appName);
        String txName = txNormalizer.normalize(this.priorityTransactionName.getName());
        if (txName == null) {
            this.setIgnore(true);
            return;
        }
        if (txName != this.priorityTransactionName.getName()) {
            this.setPriorityTransactionName(PriorityTransactionName.create(txName, TransactionNamePriority.REQUEST_URI));
        }
    }

    public void setPriorityTransactionName(PriorityTransactionName ptn) {
        if (ptn == null) {
            return;
        }
        if (null != this.transactionNameListeners) {
            for (TransactionNameListener transactionNameListener : this.transactionNameListeners) {
                try {
                    transactionNameListener.noticeTransactionName(ptn);
                }
                catch (UnmodifiableTransactionNameException e) {
                    this.priorityTransactionName = this.priorityTransactionName.freeze();
                    return;
                }
            }
        }
        this.priorityTransactionName = ptn;
    }

    public void setTransactionNameListener(TransactionNameListener transactionNameListener) {
        if (null == this.transactionNameListeners) {
            this.transactionNameListeners = new ArrayList<TransactionNameListener>();
        }
        this.transactionNameListeners.add(transactionNameListener);
    }

    public PriorityApplicationName getPriorityApplicationName() {
        return this.priorityApplicationName;
    }

    public void setPriorityApplicationName(PriorityApplicationName pan) {
        if (pan == null) {
            return;
        }
        this.priorityApplicationName = pan;
    }

    @Override
    public String getApplicationName() {
        return this.priorityApplicationName.getName();
    }

    public int getStackTraceCount() {
        return this.stackTraceCount;
    }

    public SqlTracerListener getSqlTracerListener() {
        if (this.sqlTracerListener == null) {
            String appName = this.getApplicationName();
            this.sqlTracerListener = ServiceFactory.getSqlTraceService().getSqlTracerListener(appName);
        }
        return this.sqlTracerListener;
    }

    public void incrementStackTraceCount() {
        ++this.stackTraceCount;
    }

    public int getExplainPlanCount() {
        return this.explainPlanCount;
    }

    public void incrementExplainPlanCount() {
        ++this.explainPlanCount;
    }

    public TransactionCache getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public DispatcherTracer getRootTracer() {
        return this.rootTracer;
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public long getExternalTime() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return ((WebRequestDispatcher)this.dispatcher).getQueueTime();
        }
        return 0L;
    }

    @Override
    public Tracer getLastTracer() {
        return this.lastTracer;
    }

    public Collection<Tracer> getTracers() {
        return this.tracers;
    }

    public Tracer tracerStarted(Tracer tracer) {
        boolean isRoot;
        if (this.reportedStall) {
            return null;
        }
        if (this.isTracerStartLocked()) {
            Agent.LOG.warning("tracerStarted but tracerStartLock is already active");
            return null;
        }
        boolean bl = isRoot = this.rootTracer == null;
        if (isRoot) {
            if (tracer instanceof IOTracer) {
                Transaction.clearTransaction();
                return null;
            }
            if (!(tracer instanceof DispatcherTracer)) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    String msg = MessageFormat.format("Non-dispatcher tracer of type {0} at the top of a transaction stack", tracer.getClass().getName());
                    if (Agent.isDebugEnabled()) {
                        Agent.LOG.log(Level.FINEST, msg, new Exception());
                    } else {
                        Agent.LOG.finest(msg);
                    }
                }
                Transaction.clearTransaction();
                return null;
            }
            this.setRootTracer((DispatcherTracer)tracer);
        } else if (tracer.getParentTracer() != null) {
            this.lastTracer = tracer;
            if (tracer.isTransactionSegment()) {
                ++this.segmentCount;
                this.overTracerSegmentLimit = this.segmentCount > this.maxSegments;
                this.incrementSize(128);
                if (!isRoot) {
                    this.tracers.add(tracer);
                }
            }
        } else if (Agent.LOG.isLoggable(Level.FINEST)) {
            Agent.LOG.finest(MessageFormat.format("Tracer cannot be added to stack because it is missing a parent pointer: {0}", tracer));
        }
        return tracer;
    }

    private void setRootTracer(DispatcherTracer tracer) {
        this.rootTracer = tracer;
        this.lastTracer = tracer;
        if (this.dispatcher == null) {
            this.dispatcher = tracer;
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void tracerFinished(Tracer tracer, int opcode) {
        if (tracer instanceof SkipTracer) {
            return;
        }
        if (tracer != this.lastTracer) {
            this.release();
            Transaction.clearTransaction();
        } else {
            if (tracer == this.rootTracer) {
                this.finished(this.rootTracer, opcode);
                return;
            }
            this.lastTracer = tracer.getParentTracer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(DispatcherTracer tracer, int opcode) {
        try {
            this.doFinish(tracer, opcode);
        }
        finally {
            Transaction.clearTransaction();
            this.release();
        }
    }

    private void doFinish(DispatcherTracer tracer, int opcode) {
        Map<Object, Object> params;
        String requestURI = tracer.getUri();
        IRPMService rpmService = this.getRPMService();
        Throwable reportError = this.getReportError();
        this.freezeTransactionName();
        if (this.ignore) {
            String msg = MessageFormat.format("Ignoring transaction {0}", requestURI);
            Agent.LOG.finer(msg);
            return;
        }
        String txName = this.priorityTransactionName.getName();
        this.dispatcher.transactionFinished(txName);
        this.recordCpuAndGCTime(tracer);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Transaction{4} {5} finished {0}ms {1}{2} for {3}", tracer.getDurationInMilliseconds(), tracer.getParameters(), opcode == 191 ? " with error" : "", requestURI, tracer instanceof DispatcherTracer ? "(dispatch)" : "", this);
            Agent.LOG.finer(msg);
        }
        if (!ServiceFactory.getServiceManager().isStarted()) {
            return;
        }
        ITransactionTracerConfig ttConfig = this.getTransactionTracerConfig();
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Transaction name for {0} is {1}", requestURI, txName);
            Agent.LOG.finer(msg);
            if (this.isAutoAppNamingEnabled()) {
                msg = MessageFormat.format("Application name for {0} is {1}", txName, rpmService.getApplicationName());
                Agent.LOG.finer(msg);
            }
        }
        if (this.isInteresting()) {
            params = this.parameters;
            params.put("thread_name", Thread.currentThread().getName());
            if (this.isOverTracerSegmentLimit()) {
                params.put("segment_clamp", this.segmentCount);
            }
            if (this.isOverSizeLimit()) {
                params.put(SIZE_LIMIT_PARAMETER_NAME, "The transaction size limit was reached");
            }
            if (this.stackTraceCount >= ttConfig.getMaxStackTraces()) {
                params.put("stack_trace_clamp", this.stackTraceCount);
            }
            if (this.explainPlanCount >= ttConfig.getMaxExplainPlans()) {
                params.put("explain_plan_clamp", this.explainPlanCount);
            }
            if (this.responseStatus > 0) {
                params.put("http_status", this.responseStatus);
            }
            if (this.statusMessage != null) {
                params.put("http_status_message", this.statusMessage);
            }
        } else {
            params = Collections.emptyMap();
            this.parameters.clear();
        }
        TransactionData transactionData = new TransactionData(tracer, this.dispatcher, opcode, reportError, requestURI, txName, params, this.isTraceDisabled(), this.responseStatus, this.statusMessage, this.transactionSize, Thread.currentThread().getId(), rpmService.getApplicationName(), ttConfig, this.getStartTime(), this.sqlTracerListener, this.tracers, this.getGuidString(false));
        ServiceFactory.getTransactionService().processTransaction(transactionData, this.transactionStats);
    }

    private void recordCpuAndGCTime(Tracer tracer) {
        if (!this.ttEnabled) {
            return;
        }
        TransactionTraceService transactionTraceService = ServiceFactory.getTransactionTraceService();
        if (tracer.getDuration() > this.getTransactionTracerConfig().getTransactionThresholdInNanos()) {
            long gcTime;
            if (this.cpuStartTimeInNanos > 0L) {
                long cpuTime = transactionTraceService.getThreadMXBean().getCurrentThreadCpuTime() - this.cpuStartTimeInNanos;
                this.parameters.put(CPU_TIME_PARAMETER_NAME, cpuTime);
            }
            if (this.startGCTimeInMillis > 0L && (gcTime = this.getGCTime()) != this.startGCTimeInMillis) {
                long totalGCTime = gcTime - this.startGCTimeInMillis;
                this.parameters.put(GC_TIME_PARAMETER_NAME, totalGCTime);
                this.transactionStats.getUnscopedStats().getResponseTimeStats("GC/cumulative").recordResponseTime(totalGCTime, TimeUnit.MILLISECONDS);
            }
        }
    }

    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    public boolean isTransactionNamingEnabled() {
        return this.transactionNamingEnabled;
    }

    public boolean isWebTransaction() {
        return this.dispatcher != null && this.dispatcher.isWebTransaction();
    }

    public IRPMService getRPMService() {
        return ServiceFactory.getRPMServiceManager().getOrCreateRPMService(this.getPriorityApplicationName());
    }

    public boolean isTraceDisabled() {
        return this.traceDisabled;
    }

    public void setTraceDisabled(boolean traceDisabled) {
        this.traceDisabled = traceDisabled;
    }

    public static void clearTransaction() {
        transactionHolder.remove();
    }

    public static void setTransaction(Transaction tx) {
        transactionHolder.set(tx);
    }

    private void release() {
        this.clearInternalParameters();
        this.transactionCache.clear();
        this.throwable = null;
    }

    public static Transaction getTransaction() {
        return transactionHolder.get();
    }

    public void lockTracerStart() {
        --this.tracerStartLock;
    }

    public void unlockTracerStart() {
        ++this.tracerStartLock;
    }

    public boolean isTracerStartLocked() {
        return this.tracerStartLock < 0;
    }

    @Deprecated
    public void setNormalizedUri(String normalizedUri) {
        if (normalizedUri == null || normalizedUri.length() == 0) {
            return;
        }
        SameOrHigherPriorityTransactionNamingPolicy policy = SameOrHigherPriorityTransactionNamingPolicy.getInstance();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(this, TransactionNamePriority.REQUEST_ATTRIBUTE)) {
            String msg = MessageFormat.format("Setting transaction name to normalized URI \"{0}\"", normalizedUri);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(this, normalizedUri, "NormalizedUri", TransactionNamePriority.REQUEST_ATTRIBUTE);
        this.normalizedUri = normalizedUri;
    }

    @Deprecated
    public String getNormalizedUri() {
        return this.normalizedUri;
    }

    public Throwable getReportError() {
        return ServletUtils.getReportError(this.throwable);
    }

    public void setStatus(int status) {
        if (this.responseStatus < 400) {
            this.responseStatus = status;
        }
    }

    public int getStatus() {
        return this.responseStatus;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        if (statusMessage != null) {
            this.statusMessage = statusMessage;
        }
    }

    public void setThrowable(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer(MessageFormat.format("Set throwable in transaction: {0}", throwable.getClass().getName()));
        }
        this.throwable = throwable;
    }

    public boolean isOverTracerSegmentLimit() {
        return this.overTracerSegmentLimit;
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }

    public long getResponseTimeInMillis() {
        if (this.rootTracer == null) {
            return 0L;
        }
        long duration = this.rootTracer.getDurationInMilliseconds();
        return duration > 0L ? duration : TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS) - this.rootTracer.getStartTimeInMilliseconds();
    }

    public void setIgnore(boolean ignore) {
        if (this.rootTracer != null) {
            this.ignore = ignore;
        } else {
            Agent.LOG.log(Level.FINEST, "setIgnore called outside of an open transaction");
        }
    }

    public void incrementSize(int size) {
        this.transactionSize += size;
    }

    private boolean isOverSizeLimit() {
        return this.transactionSize > this.transactionSizeLimit;
    }

    public boolean shouldGenerateTransactionSegment() {
        return this.ttEnabled && !this.isOverTracerSegmentLimit() && !this.isOverSizeLimit();
    }

    public DatabaseStatementParser getDatabaseStatementParser() {
        if (this.databaseStatementParser == null) {
            this.databaseStatementParser = this.createDatabaseStatementParser();
        }
        return this.databaseStatementParser;
    }

    private DatabaseStatementParser createDatabaseStatementParser() {
        return new CachingDatabaseStatementParser(ServiceFactory.getDatabaseService().getDatabaseStatementParser());
    }

    public boolean isInteresting() {
        if (this.throwable != null) {
            return true;
        }
        if (this.getStatus() >= 400) {
            return true;
        }
        if (!this.ttEnabled) {
            return false;
        }
        if (this.guid != null) {
            return true;
        }
        if (this.rootTracer.getDuration() <= this.getTransactionTracerConfig().getTransactionThresholdInNanos()) {
            return false;
        }
        return ServiceFactory.getTransactionTraceService().isInteresting(this.dispatcher, this.rootTracer);
    }

    @Override
    public String getGuidString(boolean generate) {
        if (null == this.guid) {
            if (generate && null != this.getRPMService().getApplicationIdentifier()) {
                this.guid = ServiceFactory.getTransactionTraceService().generateGuid();
            } else {
                return null;
            }
        }
        return this.guid;
    }

    public String getNewGuid() {
        return this.getRPMService().getApplicationIdentifier() == null ? null : ServiceFactory.getTransactionTraceService().generateGuid();
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public BeaconTransactionState getBeaconTransactionState() {
        if (this.beaconTransactionState == null) {
            this.beaconTransactionState = BeaconTransactionStateImpl.create(this);
        }
        return this.beaconTransactionState;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }
}

