/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.sql.SqlTracerListener;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.Tracer;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionData {
    private final Tracer rootTracer;
    private final int opcode;
    private final String requestUri;
    private final Map<String, Object> parameters;
    private final String blameMetricName;
    private final Throwable throwable;
    private final boolean traceDisabled;
    private final int responseStatus;
    private final String statusMessage;
    private final int transactionSize;
    private final long threadId;
    private final String appName;
    private final ITransactionTracerConfig transactionTracerConfig;
    private final long startTime;
    private final SqlTracerListener sqlTracerListener;
    private final Collection<Tracer> tracers;
    private final Dispatcher dispatcher;
    private final String guid;

    public TransactionData(Tracer tracer, Dispatcher dispatcher, int opcode, Throwable throwable, String requestUri, String frontendMetricName, Map<String, Object> parameters, boolean traceDisabled, int responseStatus, String statusMessage, int transactionSize, long threadId, String appName, ITransactionTracerConfig ttConfig, long startTime, SqlTracerListener sqlTracerListener, Collection<Tracer> tracers, String transactionGuid) {
        this.throwable = throwable;
        this.tracers = tracers;
        this.rootTracer = tracer;
        this.dispatcher = dispatcher;
        this.opcode = opcode;
        this.requestUri = requestUri;
        this.blameMetricName = frontendMetricName;
        this.parameters = parameters;
        this.traceDisabled = traceDisabled;
        this.responseStatus = responseStatus;
        this.statusMessage = statusMessage;
        this.transactionSize = transactionSize;
        this.threadId = threadId;
        this.appName = appName;
        this.transactionTracerConfig = ttConfig;
        this.startTime = startTime;
        this.sqlTracerListener = sqlTracerListener;
        this.guid = transactionGuid;
    }

    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public Collection<Tracer> getTracers() {
        return this.tracers;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeInNanos() {
        return this.rootTracer.getStartTime();
    }

    public long getEndTimeInNanos() {
        return this.rootTracer.getEndTime();
    }

    public int getOpcode() {
        return this.opcode;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public ITransactionTracerConfig getTransactionTracerConfig() {
        return this.transactionTracerConfig;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getBlameMetricName() {
        return this.blameMetricName;
    }

    public String getBlameOrRootMetricName() {
        return this.blameMetricName == null ? this.rootTracer.getMetricName() : this.blameMetricName;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected final int getTransactionSize() {
        return this.transactionSize;
    }

    public long getDurationInMillis() {
        return this.rootTracer.getDurationInMilliseconds();
    }

    public long getDuration() {
        return this.rootTracer.getDuration();
    }

    public String getGuid() {
        return this.guid;
    }

    public boolean getForcePersist() {
        return this.guid != null && this.guid.length() > 0;
    }

    public boolean isTraceDisabled() {
        return this.traceDisabled;
    }

    public String toString() {
        String name = this.requestUri == null ? this.rootTracer.getMetricName() : this.requestUri;
        StringBuilder builder = new StringBuilder(name == null ? "" : name).append(' ').append(this.getDurationInMillis()).append("ms");
        if (this.throwable != null) {
            builder.append(' ').append(this.throwable.toString());
        }
        return builder.toString();
    }

    public boolean isWebTransaction() {
        return this.dispatcher.isWebTransaction();
    }

    public SqlTracerListener getSqlTracerListener() {
        return this.sqlTracerListener;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }
}

