/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.IErrorCollectorConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.transaction.MergeStatsEngineResolvingScope;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionService
extends AbstractService
implements HarvestListener {
    private static final ThreadLocal<Boolean> NOTICE_REQUEST_THREAD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<Boolean> NOTICE_BACKGROUND_THREAD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final List<TransactionListener> transactionListeners = new CopyOnWriteArrayList<TransactionListener>();
    private final Map<Long, RunningTransaction> transactionThreadMap = new ConcurrentHashMap<Long, RunningTransaction>();
    private final long stallThresholdInNanoseconds;

    public TransactionService() {
        super(TransactionService.class.getSimpleName());
        IErrorCollectorConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig().getErrorCollectorConfig();
        this.stallThresholdInNanoseconds = config.getStallThresholdInNanos();
    }

    public static void noticeRequestThread(long threadId) {
        if (NOTICE_REQUEST_THREAD.get().booleanValue()) {
            return;
        }
        ServiceFactory.getThreadService().noticeRequestThread(threadId);
        NOTICE_REQUEST_THREAD.set(Boolean.TRUE);
    }

    public static void noticeBackgroundThread(long threadId) {
        if (NOTICE_BACKGROUND_THREAD.get().booleanValue()) {
            return;
        }
        ServiceFactory.getThreadService().noticeBackgroundThread(threadId);
        NOTICE_BACKGROUND_THREAD.set(Boolean.TRUE);
    }

    public void processTransaction(TransactionData transactionData, TransactionStats transactionStats) {
        try {
            this.doProcessTransaction(transactionData, transactionStats);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error recording transaction \"{0}\": {1}", transactionData.getBlameMetricName(), e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().warning(msg);
        }
    }

    private void doProcessTransaction(TransactionData transactionData, TransactionStats transactionStats) {
        if (!ServiceFactory.getServiceManager().isStarted() || !ServiceFactory.getAgent().isEnabled()) {
            return;
        }
        if (Agent.isDebugEnabled()) {
            this.getLogger().finer("Recording metrics for " + transactionData);
        }
        String transactionSizeMetric = "Supportability/TransactionSize";
        boolean sizeLimitExceeded = transactionData.getParameters().get("size_limit") != null;
        transactionStats.getUnscopedStats().getStats(transactionSizeMetric).recordDataPoint(transactionData.getTransactionSize());
        if (sizeLimitExceeded) {
            transactionStats.getUnscopedStats().getStats("Supportability/TransactionSizeClamp").incrementCallCount();
        }
        if (transactionData.isWebTransaction()) {
            TransactionService.noticeRequestThread(transactionData.getThreadId());
        } else {
            TransactionService.noticeBackgroundThread(transactionData.getThreadId());
        }
        if (transactionData.getRootTracer() instanceof DispatcherTracer) {
            for (TransactionListener listener : this.transactionListeners) {
                listener.dispatcherTransactionFinished(transactionData, transactionStats);
            }
        } else if (Agent.isDebugEnabled()) {
            this.getLogger().finer("Skipping transaction trace for " + transactionData);
        }
        StatsService statsService = ServiceFactory.getStatsService();
        MergeStatsEngineResolvingScope statsWork = new MergeStatsEngineResolvingScope(transactionData.getBlameMetricName(), transactionData.getApplicationName(), transactionStats);
        statsService.doStatsWork(statsWork);
    }

    @Override
    protected void doStart() {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        this.transactionListeners.clear();
        this.transactionThreadMap.clear();
    }

    public void addTransaction(Transaction tx) {
        long id = Thread.currentThread().getId();
        this.transactionThreadMap.put(id, new RunningTransaction(tx, id));
    }

    public void removeTransaction() {
        this.transactionThreadMap.remove(Thread.currentThread().getId());
    }

    public Set<Long> getRunningThreadsIds() {
        HashSet<Long> runningThreadIds = new HashSet<Long>();
        for (Map.Entry<Long, RunningTransaction> entry : this.transactionThreadMap.entrySet()) {
            RunningTransaction runningTransaction = entry.getValue();
            if (runningTransaction.isEmpty()) continue;
            runningThreadIds.add(entry.getKey());
        }
        return runningThreadIds;
    }

    public Set<Long> getThreadsIds() {
        return new HashSet<Long>(this.transactionThreadMap.keySet());
    }

    public void addTransactionListener(TransactionListener listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.transactionListeners.remove(listener);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer(MessageFormat.format("Checking {0} running transactions for stalls", this.transactionThreadMap.size()));
        }
        int stallCount = 0;
        for (RunningTransaction runningTransaction : this.transactionThreadMap.values()) {
            long threadUserTimeInNanoseconds;
            if (runningTransaction.shouldRemove(this.stallThresholdInNanoseconds)) {
                this.transactionThreadMap.remove(runningTransaction.getThreadId());
            }
            if (runningTransaction.isIgnore() || (threadUserTimeInNanoseconds = runningTransaction.getRunningTime()) <= this.stallThresholdInNanoseconds) continue;
            ++stallCount;
            runningTransaction.reportAsStall();
        }
        if (stallCount > 0) {
            statsEngine.getStats("Stalls").incrementCallCount(stallCount);
            if (Agent.isDebugEnabled()) {
                System.err.println("Stall count: " + stallCount);
            }
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class RunningTransaction {
        private final Transaction tx;
        private final long threadId;
        private final long startTime;

        public RunningTransaction(Transaction tx, long threadId) {
            this.tx = tx;
            this.threadId = threadId;
            this.startTime = System.nanoTime();
        }

        public long getThreadId() {
            return this.threadId;
        }

        public void reportAsStall() {
            this.tx.reportAsStall(this.threadId);
        }

        public boolean isIgnore() {
            return this.tx.isIgnore();
        }

        public long getRunningTime() {
            DispatcherTracer rootTracer = this.tx.getRootTracer();
            if (rootTracer == null) {
                return 0L;
            }
            return System.nanoTime() - rootTracer.getStartTime();
        }

        public boolean isEmpty() {
            return this.tx.getRootTracer() == null;
        }

        public boolean shouldRemove(long stallThresholdInNanoseconds) {
            if (this.tx.getRootTracer() != null) {
                return false;
            }
            if (System.nanoTime() - this.startTime <= stallThresholdInNanoseconds) {
                return false;
            }
            return this.hasThreadTerminated();
        }

        public boolean hasThreadTerminated() {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(this.threadId, 0);
            if (threadInfo == null) {
                return true;
            }
            return threadInfo.getThreadState() == Thread.State.TERMINATED;
        }

        public String toString() {
            return this.tx.toString();
        }
    }
}

