/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import java.text.MessageFormat;
import java.util.logging.Level;

public class TransactionStateImpl
implements TransactionState {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer(Transaction tx, TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
        if (tx.isIgnore() || tx.isTracerStartLocked()) {
            return null;
        }
        Tracer tracer = null;
        try {
            tx.lockTracerStart();
            tracer = tracerFactory.getTracer(tx, signature, object, args);
        }
        finally {
            tx.unlockTracerStart();
        }
        if (tracer == null || tracer instanceof SkipTracer) {
            return tracer;
        }
        if ((tracer = tx.tracerStarted(tracer)) != null && Agent.LOG.isLoggable(Level.FINEST)) {
            if (tracer == tx.getRootTracer()) {
                Agent.LOG.finest(MessageFormat.format("Transaction started {0}", tx));
            }
            Agent.LOG.finest(MessageFormat.format("trace: {0}.{1}{2}", signature.getClassName(), signature.getMethodName(), signature.getMethodDesc()));
        }
        return tracer;
    }

    public void resume() {
    }

    public void suspend() {
    }

    public void complete() {
    }

    public boolean finish(Transaction tx, Tracer tracer) {
        return true;
    }

    public void suspendRootTracer() {
    }
}

