/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.application;

import com.newrelic.agent.util.Obfuscator;
import java.io.UnsupportedEncodingException;

public class RemoteApplicationInfo {
    private static final String OBFUSCATION_KEY = "AppMonitoring";
    private final String transactionName;
    private final String applicationIdentifier;

    public RemoteApplicationInfo(String appId, String encodedTransactionName) throws UnsupportedEncodingException {
        this.transactionName = Obfuscator.deobfuscateNameUsingKey(encodedTransactionName, OBFUSCATION_KEY);
        this.applicationIdentifier = appId;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public String toString() {
        return this.applicationIdentifier.toString() + ":" + this.transactionName;
    }

    public static String obfuscateTransactionName(String transactionName) throws UnsupportedEncodingException {
        return Obfuscator.obfuscateNameUsingKey(transactionName, OBFUSCATION_KEY);
    }
}

