/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.beacon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.beacon.BeaconTransactionState;
import com.newrelic.agent.beacon.IBeaconConfig;
import com.newrelic.agent.config.Config2;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.Obfuscator;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeaconConfig
extends Config2
implements IBeaconConfig {
    public static final String EPISODES_FILE = "episodes_file";
    public static final String BEACON = "beacon";
    public static final String BROWSER_KEY = "browser_key";
    public static final String APPLICATION_ID = "application_id";
    public static final String LOAD_EPISODES_FILE = "rum.load_episodes_file";
    public static final String JSONP = "rum.jsonp";
    public static final boolean DEFAULT_LOAD_EPISODES_FILE = true;
    public static final boolean DEFAULT_JSONP = true;
    private static final String NRF2_COMMAND = "nrf2";
    private static final String NRFJ_COMMAND = "nrfj";
    private static final String HEADER = "<script type=\"text/javascript\">var NREUMQ=NREUMQ||[];NREUMQ.push([\"mark\",\"firstbyte\",new Date().getTime()])</script>";
    private static final String FOOTER_BEFORE_EPISODES_FILE = "<script type=\"text/javascript\">if (!NREUMQ.f) { NREUMQ.f=function() {NREUMQ.push([\"load\",new Date().getTime()]);var e=document.createElement(\"script\");e.type=\"text/javascript\";e.src=((\"http:\"===document.location.protocol)?\"http:\":\"https:\") + \"//\" + \"";
    private static final String FOOTER_AFTER_EPISODES_FILE = "\";document.body.appendChild(e);if(NREUMQ.a)NREUMQ.a();};NREUMQ.a=window.onload;window.onload=NREUMQ.f;};";
    private static final String FOOTER_BEGIN_PATTERN = "NREUMQ.push([\"{0}\",\"{1}\",\"{2}\",\"{3}\",";
    private static final String FOOTER_END_NRF2_PATTERN = "\"{0}\",{1},{2},new Date().getTime()]);</script>";
    private static final String FOOTER_END_NRFJ_PATTERN = "\"{0}\",{1},{2},new Date().getTime(),\"{3}\",\"{4}\",\"{5}\",\"{6}\",\"{7}\"]);</script>";
    private static final int APPROXIMATE_FOOTER_SIZE = 1000;
    private final String footerBegin;
    private final boolean loadJsFile;
    private final String episodesFile;
    private final boolean useNrfj = this.getProperty("rum.jsonp", true);

    private BeaconConfig(Map<String, Object> props) throws Exception {
        super(props, null);
        this.loadJsFile = this.getProperty(LOAD_EPISODES_FILE, true);
        this.episodesFile = this.initEpisodesFile();
        this.footerBegin = this.initFooterBegin();
    }

    private String initEpisodesFile() throws Exception {
        String episodesFile = this.getRequiredProperty(EPISODES_FILE);
        return this.loadJsFile ? episodesFile : null;
    }

    private String initFooterBegin() throws Exception {
        String command = this.useNrfj ? NRFJ_COMMAND : NRF2_COMMAND;
        String beaconAddress = this.getRequiredProperty(BEACON);
        String browserMonitorKey = this.getRequiredProperty(BROWSER_KEY);
        String applicationId = this.getRequiredProperty(APPLICATION_ID);
        return MessageFormat.format(FOOTER_BEGIN_PATTERN, command, beaconAddress, browserMonitorKey, applicationId);
    }

    public String getRequiredProperty(String key) throws Exception {
        Object val = this.getProperty(key, null);
        if (val == null) {
            String msg = MessageFormat.format("Real User Monitoring value for {0} is missing", key);
            throw new Exception(msg);
        }
        return val.toString();
    }

    @Override
    public String getBrowserTimingHeader() {
        return HEADER;
    }

    @Override
    public String getBrowserTimingFooter(BeaconTransactionState state) {
        StringBuilder footer = new StringBuilder(1000);
        if (this.loadJsFile) {
            footer.append(FOOTER_BEFORE_EPISODES_FILE).append(this.episodesFile).append(FOOTER_AFTER_EPISODES_FILE);
        } else {
            footer.append("<script>");
        }
        String footerEnd = this.getFooterEnd(state);
        return footer.append(this.footerBegin).append(footerEnd).toString();
    }

    private String getFooterEnd(BeaconTransactionState state) {
        if (this.useNrfj) {
            return this.getNrfjFooterEnd(state);
        }
        return this.getNrf2FooterEnd(state);
    }

    private String getNrfjFooterEnd(BeaconTransactionState state) {
        String transactionName = this.obfuscate(state.getTransactionName());
        String externalTime = String.valueOf(state.getExternalTimeInMilliseconds());
        String appTime = String.valueOf(state.getDurationInMilliseconds());
        String traceToken = state.getTraceToken();
        traceToken = traceToken == null ? "" : traceToken;
        String guid = state.getGuid();
        guid = guid == null ? "" : guid;
        String userName = this.obfuscate(state.getUserName());
        String accountName = this.obfuscate(state.getAccountName());
        String productName = this.obfuscate(state.getProductName());
        return MessageFormat.format(FOOTER_END_NRFJ_PATTERN, transactionName, externalTime, appTime, guid, traceToken, userName, accountName, productName);
    }

    private String getNrf2FooterEnd(BeaconTransactionState state) {
        String obfuscatedTransactionName = this.obfuscate(state.getTransactionName());
        String externalTime = String.valueOf(state.getExternalTimeInMilliseconds());
        String appTime = String.valueOf(state.getDurationInMilliseconds());
        return MessageFormat.format(FOOTER_END_NRF2_PATTERN, obfuscatedTransactionName, externalTime, appTime);
    }

    private String obfuscate(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        String licenseKey = ServiceFactory.getConfigService().getDefaultAgentConfig().getLicenseKey();
        try {
            return Obfuscator.obfuscateNameUsingKey(name, licenseKey.substring(0, 13));
        }
        catch (UnsupportedEncodingException e) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Error obfuscating \"{0}\": {1}", name, e);
                Agent.LOG.finer(msg);
            }
            return "";
        }
    }

    public static IBeaconConfig createBeaconConfig(Map<String, Object> settings) throws Exception {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new BeaconConfig(settings);
    }
}

