/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BrowserMonitoringConfigImpl;
import com.newrelic.agent.config.ClassTransformerConfigImpl;
import com.newrelic.agent.config.Config2;
import com.newrelic.agent.config.ErrorCollectorConfigImpl;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.config.IBrowserMonitoringConfig;
import com.newrelic.agent.config.IClassTransformerConfig;
import com.newrelic.agent.config.IErrorCollectorConfig;
import com.newrelic.agent.config.INamedTransactionConfig;
import com.newrelic.agent.config.IThreadProfilerConfig;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.config.NamedTransactionConfigImpl;
import com.newrelic.agent.config.SqlTraceConfig;
import com.newrelic.agent.config.SqlTraceConfigImpl;
import com.newrelic.agent.config.ThreadProfilerConfigImpl;
import com.newrelic.agent.config.TransactionTracerConfigImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentConfigImpl
extends Config2
implements IAgentConfig {
    public static final String APDEX_T = "apdex_t";
    public static final String API_HOST = "api_host";
    public static final String API_PORT = "api_port";
    public static final String APP_NAME = "app_name";
    public static final String AUDIT_MODE = "audit_mode";
    public static final String BROWSER_MONITORING = "browser_monitoring";
    public static final String CLASS_TRANSFORMER = "class_transformer";
    public static final String CAPTURE_PARAMS = "capture_params";
    public static final String CPU_SAMPLING_ENABLED = "cpu_sampling_enabled";
    public static final String CROSS_PROCESS_FEATURE_ENABLED = "cross_process_feature_enabled";
    public static final String DEBUG = "newrelic.debug";
    public static final String AGENT_ENABLED = "agent_enabled";
    public static final String ENABLED = "enabled";
    public static final String ENABLE_AUTO_APP_NAMING = "enable_auto_app_naming";
    public static final String ENABLE_AUTO_TRANSACTION_NAMING = "enable_auto_transaction_naming";
    public static final String ENABLE_BOOTSTRAP_CLASS_INSTRUMENTATION = "enable_bootstrap_class_instrumentation";
    public static final String ENABLE_CUSTOM_TRACING = "enable_custom_tracing";
    public static final String ERROR_COLLECTOR = "error_collector";
    public static final String EXT_CONFIG_DIR = "extensions.dir";
    public static final String HOST = "host";
    public static final String IGNORED_PARAMS = "ignored_params";
    public static final String ENABLE_SESSION_COUNT_TRACKING = "enable_session_count_tracking";
    public static final String IS_SSL = "ssl";
    public static final String LANGUAGE = "language";
    public static final String LICENSE_KEY = "license_key";
    public static final String LOG_FILE_COUNT = "log_file_count";
    public static final String LOG_FILE_NAME = "log_file_name";
    public static final String LOG_FILE_PATH = "log_file_path";
    public static final String LOG_LEVEL = "log_level";
    public static final String LOG_LIMIT = "log_limit_in_kbytes";
    public static final String NAMED_TRANSACTION = "web_transactions_apdex";
    public static final String PORT = "port";
    public static final String PROXY_HOST = "proxy_host";
    public static final String PROXY_PORT = "proxy_port";
    public static final String PROXY_USER = "proxy_user";
    public static final String PROXY_PASS = "proxy_password";
    public static final String REPORT_SQL_PARSER_ERRORS = "report_sql_parser_errors";
    public static final String SEND_DATA_ON_EXIT = "send_data_on_exit";
    public static final String SEND_DATA_ON_EXIT_THRESHOLD = "send_data_on_exit_threshold";
    public static final String SEND_ENVIRONMENT_INFO = "send_environment_info";
    public static final String SLOW_SQL = "slow_sql";
    public static final String STDOUT = "STDOUT";
    public static final String SYNC_STARTUP = "sync_startup";
    public static final String THREAD_PROFILER = "thread_profiler";
    public static final String TRANSACTION_SIZE_LIMIT = "transaction_size_limit";
    public static final String TRANSACTION_TRACER = "transaction_tracer";
    public static final String THREAD_CPU_TIME_ENABLED = "thread_cpu_time_enabled";
    public static final String THREAD_PROFILER_ENABLED = "enabled";
    public static final String TRACE_DATA_CALLS = "trace_data_calls";
    public static final String WAIT_FOR_RPM_CONNECT = "wait_for_rpm_connect";
    public static final double DEFAULT_APDEX_T = 1.0;
    public static final String DEFAULT_API_HOST = "rpm.newrelic.com";
    public static final boolean DEFAULT_AUDIT_MODE = false;
    public static final boolean DEFAULT_CAPTURE_PARAMS = false;
    public static final boolean DEFAULT_CPU_SAMPLING_ENABLED = true;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_ENABLE_AUTO_APP_NAMING = false;
    public static final boolean DEFAULT_ENABLE_AUTO_TRANSACTION_NAMING = true;
    public static final boolean DEFAULT_ENABLE_CUSTOM_TRACING = true;
    public static final boolean DEFAULT_ENABLE_SESSION_COUNT_TRACKING = false;
    public static final String DEFAULT_HOST = "collector.newrelic.com";
    public static final boolean DEFAULT_IS_SSL = false;
    public static final String DEFAULT_LANGUAGE = "java";
    public static final int DEFAULT_LOG_FILE_COUNT = 1;
    public static final String DEFAULT_LOG_FILE_NAME = "newrelic_agent.log";
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final int DEFAULT_LOG_LIMIT = 0;
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_PROXY_HOST = null;
    public static final int DEFAULT_PROXY_PORT = 8080;
    public static final boolean DEFAULT_REPORT_SQL_PARSER_ERRORS = false;
    public static final boolean DEFAULT_SEND_DATA_ON_EXIT = false;
    public static final int DEFAULT_SEND_DATA_ON_EXIT_THRESHOLD = 60;
    public static final boolean DEFAULT_SEND_ENVIRONMENT_INFO = true;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final boolean DEFAULT_SYNC_STARTUP = false;
    public static final boolean DEFAULT_TRACE_DATA_CALLS = false;
    public static final int DEFAULT_TRANSACTION_SIZE_LIMIT = 2000;
    public static final boolean DEFAULT_WAIT_FOR_RPM_CONNECT = true;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.";
    private final long apdexTInMillis;
    private final boolean enabled;
    private final boolean debug;
    private final String licenseKey;
    private final String host;
    private final int port;
    private final Integer proxyPort;
    private final boolean isSSL;
    private final String appName;
    private final List<String> appNames;
    private final boolean captureParams;
    private final boolean cpuSamplingEnabled;
    private final Set<String> ignoredParams;
    private final boolean autoAppNamingEnabled;
    private final boolean autoTransactionNamingEnabled;
    private final String logLevel;
    private final String proxyHost;
    private final String proxyUser;
    private final String proxyPass;
    private final boolean sessionCountTrackingEnabled;
    private final int transactionSizeLimit;
    private final boolean reportSqlParserErrors;
    private final boolean auditMode;
    private final boolean waitForRPMConnect;
    private final TransactionTracerConfigImpl transactionTracerConfig;
    private final IErrorCollectorConfig errorCollectorConfig;
    private final SqlTraceConfig sqlTraceConfig;
    private final IThreadProfilerConfig threadProfilerConfig;
    private final TransactionTracerConfigImpl requestTransactionTracerConfig;
    private final TransactionTracerConfigImpl backgroundTransactionTracerConfig;
    private final IBrowserMonitoringConfig browserMonitoringConfig;
    private final IClassTransformerConfig classTransformerConfig;
    private final INamedTransactionConfig namedTransactionConfig;
    private final boolean isApdexTSet = this.getProperty("apdex_t") != null;
    private final boolean isCrossProcessFeatureEnabled;

    private AgentConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.apdexTInMillis = (long)(this.getDoubleProperty(APDEX_T, 1.0) * 1000.0);
        this.debug = Boolean.getBoolean(DEBUG);
        this.enabled = this.getProperty("enabled", true) != false && this.getProperty(AGENT_ENABLED, true) != false;
        this.licenseKey = (String)this.getProperty(LICENSE_KEY);
        this.host = this.getProperty(HOST, DEFAULT_HOST);
        this.isSSL = this.getProperty(IS_SSL, false);
        this.logLevel = this.initLogLevel();
        this.port = this.getIntProperty(PORT, this.isSSL ? 443 : 80);
        this.proxyHost = this.getProperty(PROXY_HOST, DEFAULT_PROXY_HOST);
        this.proxyPort = this.getIntProperty(PROXY_PORT, 8080);
        this.proxyUser = (String)this.getProperty(PROXY_USER);
        this.proxyPass = (String)this.getProperty(PROXY_PASS);
        this.appNames = new ArrayList<String>(this.getUniqueStrings(APP_NAME, ";"));
        this.appName = this.getFirstString(APP_NAME, ";");
        this.captureParams = this.getProperty(CAPTURE_PARAMS, false);
        this.cpuSamplingEnabled = this.getProperty(CPU_SAMPLING_ENABLED, true);
        this.ignoredParams = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(IGNORED_PARAMS)));
        this.autoAppNamingEnabled = this.getProperty(ENABLE_AUTO_APP_NAMING, false);
        this.autoTransactionNamingEnabled = this.getProperty(ENABLE_AUTO_TRANSACTION_NAMING, true);
        this.transactionSizeLimit = this.getIntProperty(TRANSACTION_SIZE_LIMIT, 2000) * 1024;
        this.sessionCountTrackingEnabled = this.getProperty(ENABLE_SESSION_COUNT_TRACKING, false);
        this.reportSqlParserErrors = this.getProperty(REPORT_SQL_PARSER_ERRORS, false);
        this.auditMode = this.getProperty(TRACE_DATA_CALLS, false) != false || this.getProperty(AUDIT_MODE, false) != false;
        this.waitForRPMConnect = this.getProperty(WAIT_FOR_RPM_CONNECT, true);
        this.transactionTracerConfig = this.initTransactionTracerConfig(this.apdexTInMillis);
        this.requestTransactionTracerConfig = this.transactionTracerConfig.createRequestTransactionTracerConfig(this.apdexTInMillis);
        this.backgroundTransactionTracerConfig = this.transactionTracerConfig.createBackgroundTransactionTracerConfig(this.apdexTInMillis);
        this.errorCollectorConfig = this.initErrorCollectorConfig();
        this.threadProfilerConfig = this.initThreadProfilerConfig();
        this.namedTransactionConfig = this.initNamedTransactionConfig(this.apdexTInMillis);
        this.sqlTraceConfig = this.initSqlTraceConfig();
        this.browserMonitoringConfig = this.initBrowserMonitoringConfig();
        this.classTransformerConfig = this.initClassTransformerConfig();
        this.isCrossProcessFeatureEnabled = this.getProperty(CROSS_PROCESS_FEATURE_ENABLED, true);
    }

    private String initLogLevel() {
        String val = this.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL);
        if (val instanceof Boolean) {
            return "off";
        }
        return this.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL);
    }

    private IThreadProfilerConfig initThreadProfilerConfig() {
        Map<String, Object> props = this.nestedProps(THREAD_PROFILER);
        return ThreadProfilerConfigImpl.createThreadProfilerConfig(props);
    }

    private INamedTransactionConfig initNamedTransactionConfig(long apdexTInMillis) {
        Map<String, Object> props = this.nestedProps(NAMED_TRANSACTION);
        return NamedTransactionConfigImpl.createNamedTransactionConfig(props, apdexTInMillis);
    }

    private TransactionTracerConfigImpl initTransactionTracerConfig(long apdexTInMillis) {
        Map<String, Object> props = this.nestedProps(TRANSACTION_TRACER);
        return TransactionTracerConfigImpl.createTransactionTracerConfig(props, apdexTInMillis);
    }

    private IErrorCollectorConfig initErrorCollectorConfig() {
        Map<String, Object> props = this.nestedProps(ERROR_COLLECTOR);
        return ErrorCollectorConfigImpl.createErrorCollectorConfig(props);
    }

    private SqlTraceConfig initSqlTraceConfig() {
        Map<String, Object> props = this.nestedProps(SLOW_SQL);
        return SqlTraceConfigImpl.createSqlTraceConfig(props);
    }

    private IBrowserMonitoringConfig initBrowserMonitoringConfig() {
        Map<String, Object> props = this.nestedProps(BROWSER_MONITORING);
        return BrowserMonitoringConfigImpl.createBrowserMonitoringConfig(props);
    }

    private IClassTransformerConfig initClassTransformerConfig() {
        boolean customTracingEnabled = this.getProperty(ENABLE_CUSTOM_TRACING, true);
        Map<String, Object> props = this.nestedProps(CLASS_TRANSFORMER);
        return ClassTransformerConfigImpl.createClassTransformerConfig(props, customTracingEnabled);
    }

    @Override
    public long getApdexTInMillis() {
        return this.apdexTInMillis;
    }

    @Override
    public long getApdexTInMillis(String transactionName) {
        return this.namedTransactionConfig.getApdexTInMillis(transactionName);
    }

    @Override
    public boolean isAgentEnabled() {
        return this.enabled;
    }

    @Override
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPass;
    }

    @Override
    public String getApiHost() {
        return this.getProperty(API_HOST, DEFAULT_API_HOST);
    }

    @Override
    public int getApiPort() {
        return this.getProperty(API_PORT, this.isSSL ? 443 : 80);
    }

    @Override
    public boolean isSSL() {
        return this.isSSL;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public List<String> getApplicationNames() {
        return this.appNames;
    }

    @Override
    public boolean isCaptureParams() {
        return this.captureParams;
    }

    @Override
    public boolean isCpuSamplingEnabled() {
        return this.cpuSamplingEnabled;
    }

    @Override
    public Set<String> getIgnoredParams() {
        return this.ignoredParams;
    }

    @Override
    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    @Override
    public boolean isAutoTransactionNamingEnabled() {
        return this.autoTransactionNamingEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public boolean isSessionCountTrackingEnabled() {
        return this.sessionCountTrackingEnabled;
    }

    @Override
    public String getLanguage() {
        return this.getProperty(LANGUAGE, DEFAULT_LANGUAGE);
    }

    @Override
    public boolean isSendDataOnExit() {
        return this.getProperty(SEND_DATA_ON_EXIT, false);
    }

    @Override
    public long getSendDataOnExitThresholdInMillis() {
        int valueInSecs = this.getIntProperty(SEND_DATA_ON_EXIT_THRESHOLD, 60);
        return TimeUnit.MILLISECONDS.convert(valueInSecs, TimeUnit.SECONDS);
    }

    @Override
    public boolean isAuditMode() {
        return this.auditMode;
    }

    @Override
    public boolean isReportSqlParserErrors() {
        return this.reportSqlParserErrors;
    }

    @Override
    public int getTransactionSizeLimit() {
        return this.transactionSizeLimit;
    }

    @Override
    public boolean waitForRPMConnect() {
        return this.waitForRPMConnect;
    }

    @Override
    public boolean isSyncStartup() {
        return this.getProperty(SYNC_STARTUP, false);
    }

    @Override
    public boolean isSendEnvironmentInfo() {
        return this.getProperty(SEND_ENVIRONMENT_INFO, true);
    }

    @Override
    public boolean isLoggingToStdOut() {
        String logFileName = this.getLogFileName();
        return STDOUT.equalsIgnoreCase(logFileName);
    }

    @Override
    public int getLogFileCount() {
        return this.getIntProperty(LOG_FILE_COUNT, 1);
    }

    @Override
    public String getLogFileName() {
        return this.getProperty(LOG_FILE_NAME, DEFAULT_LOG_FILE_NAME);
    }

    @Override
    public String getLogFilePath() {
        return (String)this.getProperty(LOG_FILE_PATH);
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public int getLogLimit() {
        return this.getIntProperty(LOG_LIMIT, 0);
    }

    @Override
    public ITransactionTracerConfig getTransactionTracerConfig() {
        return this.transactionTracerConfig;
    }

    @Override
    public ITransactionTracerConfig getBackgroundTransactionTracerConfig() {
        return this.backgroundTransactionTracerConfig;
    }

    @Override
    public ITransactionTracerConfig getRequestTransactionTracerConfig() {
        return this.requestTransactionTracerConfig;
    }

    @Override
    public IErrorCollectorConfig getErrorCollectorConfig() {
        return this.errorCollectorConfig;
    }

    @Override
    public SqlTraceConfig getSqlTraceConfig() {
        return this.sqlTraceConfig;
    }

    @Override
    public IThreadProfilerConfig getThreadProfilerConfig() {
        return this.threadProfilerConfig;
    }

    @Override
    public IBrowserMonitoringConfig getBrowserMonitoringConfig() {
        return this.browserMonitoringConfig;
    }

    @Override
    public IClassTransformerConfig getClassTransformerConfig() {
        return this.classTransformerConfig;
    }

    @Override
    public boolean isApdexTSet() {
        return this.isApdexTSet;
    }

    @Override
    public boolean isCrossProcessFeatureEnabled() {
        return this.isCrossProcessFeatureEnabled;
    }

    public static IAgentConfig createAgentConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new AgentConfigImpl(settings);
    }

    public static void sanitizeSettings(Map<String, Object> settings) {
        for (String setting : new String[]{PROXY_USER, PROXY_PASS}) {
            if (!settings.containsKey(setting)) continue;
            settings.put(setting, "****");
        }
    }
}

