/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentJarHelper {
    private static final String NEW_RELIC_JAR_FILE = "newrelic.jar";
    private static final String BUILT_DATE_ATTRIBUTE = "Built-Date";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> findAgentJarFileNames(Pattern pattern) {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        ZipFile jarFile = null;
        try {
            jarFile = new JarFile(URLDecoder.decode(agentJarUrl.getFile(), "UTF-8"));
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!pattern.matcher(jarEntry.getName()).matches()) continue;
                names.add(jarEntry.getName());
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (IOException e) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
        return Collections.emptyList();
    }

    public static File getAgentJarDirectory() {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        if (agentJarUrl != null) {
            try {
                File file = new File(URLDecoder.decode(agentJarUrl.getPath(), "UTF-8"));
                if (file.exists()) {
                    return file.getParentFile();
                }
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getAgentJarUrl() {
        ClassLoader classLoader;
        if (System.getProperty("newrelic.agent_jarfile") != null) {
            try {
                return new URL("file://" + System.getProperty("newrelic.agent_jarfile"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if ((classLoader = ClassLoader.getSystemClassLoader()) instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                if (!url.getFile().endsWith(NEW_RELIC_JAR_FILE)) continue;
                return url;
            }
            String agentClassName = Agent.class.getName().replace('.', '/') + ".class";
            for (URL url : urls) {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(url.getFile());
                    ZipEntry entry = jarFile.getEntry(agentClassName);
                    if (entry == null) continue;
                    URL uRL = url;
                    return uRL;
                }
                catch (IOException e) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return AgentJarHelper.class.getProtectionDomain().getCodeSource().getLocation();
    }

    private static JarFile getAgentJarFile() {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        return AgentJarHelper.getAgentJarFile(agentJarUrl);
    }

    private static JarFile getAgentJarFile(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return new JarFile(URLDecoder.decode(agentJarUrl.getFile(), "UTF-8"));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getBuildDate() {
        return AgentJarHelper.getAgentJarAttribute(BUILT_DATE_ATTRIBUTE);
    }

    public static String getAgentJarAttribute(String name) {
        JarFile jarFile = AgentJarHelper.getAgentJarFile();
        if (jarFile == null) {
            return null;
        }
        try {
            return jarFile.getManifest().getMainAttributes().getValue(name);
        }
        catch (IOException e) {
            return null;
        }
    }
}

