/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCollectorConfig
extends Config {
    private final Set<String> ignoreErrors;
    private final Set<Integer> ignoreStatusCodes = Collections.unmodifiableSet(this.initializeIgnoreStatusCodes());

    protected ErrorCollectorConfig(AgentConfig agentConfig, Map props) {
        super(props, "newrelic.config.error_collector");
        this.ignoreErrors = Collections.unmodifiableSet(this.initializeIgnoreExceptions());
    }

    private Set<Integer> initializeIgnoreStatusCodes() {
        Object ignoreStatusObj = this.getProperty("ignore_status_codes");
        if (ignoreStatusObj instanceof String) {
            String ignoreStatusValue = ignoreStatusObj.toString();
            ignoreStatusValue = ignoreStatusValue.replaceAll(" ", "");
            return this.getIgnoredStatusCodes(Arrays.asList(ignoreStatusValue.split(",")));
        }
        if (ignoreStatusObj instanceof Collection) {
            return this.getIgnoredStatusCodes((Collection)ignoreStatusObj);
        }
        if (ignoreStatusObj instanceof Integer) {
            return new HashSet<Integer>(Arrays.asList((Integer)ignoreStatusObj));
        }
        return new HashSet<Integer>(Arrays.asList(404));
    }

    private Set<Integer> getIgnoredStatusCodes(Collection errorCodes) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Object error : errorCodes) {
            try {
                int errorCode = error instanceof Number ? ((Number)error).intValue() : Integer.parseInt(error.toString());
                set.add(errorCode);
                Agent.LOG.finest(MessageFormat.format("Error collector will ignore status code {0}", errorCode));
            }
            catch (NumberFormatException e) {
                Agent.LOG.severe("Unable to parse status code " + error + " from ignore_status_codes parameter");
            }
        }
        return set;
    }

    private Set<String> initializeIgnoreExceptions() {
        Object ignoreErrorsValue = this.getProperty("ignore_errors");
        if (ignoreErrorsValue instanceof String) {
            return new HashSet<String>(Strings.trim(Arrays.asList(ignoreErrorsValue.toString().split(","))));
        }
        if (ignoreErrorsValue instanceof Collection) {
            return new HashSet<String>((Collection)ignoreErrorsValue);
        }
        return Collections.emptySet();
    }

    public Set<String> getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public Set<Integer> getIgnoreStatusCodes() {
        return this.ignoreStatusCodes;
    }

    public boolean isEnabled() {
        return this.getProperty("enabled", false);
    }
}

