/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTracerConfig
extends Config {
    public static final String BACKGROUND_BUCKET_NAME = "background";
    public static final String REQUEST_BUCKET_NAME = "request";
    public static final String OBFUSCATED_SQL_FIELDS = "obfuscated_sql_fields";
    public static final String RECORD_SQL = "record_sql";
    protected static final String LOG_SQL = "log_sql";
    protected static final String APDEX_F = "apdex_f";
    public static final String EXPLAIN_THRESHOLD = "explain_threshold";
    protected static final String TRANSACTION_THRESHOLD = "transaction_threshold";
    protected static final long DEFAULT_TRANSACTION_THRESHOLD = 2000L;
    protected static final int APDEX_F_MULTIPLE = 4;
    public static final int DEFAULT_INSERT_SQL_MAX_LENGTH = 2000;
    private final double stackTraceThresholdInMillis;
    private final double explainThresholdInMillis;
    private final int maxStackTraces;
    private final int maxSegments;
    private final int maxExplainPlans;
    private final long transactionThreshold;
    private final boolean explainEnabled;
    private final boolean gcTimeEnabled;
    private final int insertSqlMaxLength;
    private final boolean enabled;
    private volatile String recordSql;
    private final boolean logSql;
    private final boolean isTransactionThresholdApdexF;
    private final List<String> obfuscatedSqlFields;

    protected TransactionTracerConfig(AgentConfig agentConfig, Map<?, ?> props) {
        this(agentConfig, props, new TransactionTracerConfig(), "newrelic.config.transaction_tracer");
    }

    protected TransactionTracerConfig(AgentConfig agentConfig, Map<?, ?> props, TransactionTracerConfig parentConfig, String systemPropertyRoot) {
        super(props, systemPropertyRoot);
        this.enabled = this.getProperty("enabled", parentConfig.isEnabled());
        Number stackTraceThreshold = (Number)this.getProperty("stack_trace_threshold");
        this.stackTraceThresholdInMillis = stackTraceThreshold == null ? parentConfig.getStackTraceThresholdInMillis() : stackTraceThreshold.doubleValue() * 1000.0;
        Number explainThreshold = (Number)this.getProperty(EXPLAIN_THRESHOLD);
        this.explainThresholdInMillis = explainThreshold == null ? parentConfig.getExplainThresholdInMillis() : explainThreshold.doubleValue() * 1000.0;
        this.explainEnabled = this.getProperty("explain_enabled", parentConfig.isExplainEnabled());
        this.gcTimeEnabled = this.getProperty("gc_time_enabled", parentConfig.isGCTimeEnabled());
        this.maxStackTraces = this.getProperty("max_stack_trace", parentConfig.getMaxStackTraces());
        this.maxExplainPlans = this.getProperty("max_explain_plans", parentConfig.getMaxExplainPlans());
        this.maxSegments = Math.min(3000, this.getProperty("segment_limit", parentConfig.getMaxSegments()));
        this.insertSqlMaxLength = this.getProperty("insert_sql_max_length", parentConfig.getInsertSqlMaxLength());
        this.recordSql = this.initializeRecordSql(parentConfig);
        this.logSql = this.getProperty(LOG_SQL, parentConfig.isLogSql());
        Object threshold = this.getProperty(TRANSACTION_THRESHOLD);
        boolean isAdexF = APDEX_F.equals(threshold);
        if (isAdexF) {
            this.isTransactionThresholdApdexF = true;
            this.transactionThreshold = -1L;
        } else if (threshold == null) {
            this.isTransactionThresholdApdexF = parentConfig.isTransactionThresholdApdexF();
            this.transactionThreshold = parentConfig.transactionThreshold;
        } else if (threshold instanceof Number) {
            this.isTransactionThresholdApdexF = false;
            this.transactionThreshold = (long)(((Number)threshold).doubleValue() * 1000.0);
        } else {
            this.isTransactionThresholdApdexF = false;
            String msg = MessageFormat.format("Unable to parse the {0} configuration parameter - using default: {1}", TRANSACTION_THRESHOLD, 2000L);
            Agent.LOG.severe(msg);
            this.transactionThreshold = 2000L;
        }
        this.obfuscatedSqlFields = this.initializeObfuscatedSqlFields(parentConfig);
    }

    protected TransactionTracerConfig() {
        super(Collections.emptyMap(), "newrelic.config.transaction_tracer");
        this.enabled = true;
        this.stackTraceThresholdInMillis = 500.0;
        this.explainThresholdInMillis = 500.0;
        this.explainEnabled = true;
        this.gcTimeEnabled = false;
        this.maxStackTraces = 30;
        this.maxExplainPlans = 20;
        this.maxSegments = 3000;
        this.insertSqlMaxLength = 2000;
        this.recordSql = "obfuscated";
        this.logSql = false;
        this.transactionThreshold = 2000L;
        this.isTransactionThresholdApdexF = false;
        this.obfuscatedSqlFields = Collections.emptyList();
    }

    private List<String> initializeObfuscatedSqlFields(TransactionTracerConfig parentConfig) {
        Object obfuscatedSqlFieldsString = this.getProperty(OBFUSCATED_SQL_FIELDS);
        if (obfuscatedSqlFieldsString instanceof String) {
            return this.initializeObfuscatedSqlFieldsString(obfuscatedSqlFieldsString.toString());
        }
        if (obfuscatedSqlFieldsString instanceof Collection) {
            return this.initializeObfuscatedSqlFields((Collection)obfuscatedSqlFieldsString);
        }
        return parentConfig.getObfuscatedSqlFields();
    }

    private List<String> initializeObfuscatedSqlFieldsString(String obfuscatedSqlFieldsString) {
        if (obfuscatedSqlFieldsString.length() == 0) {
            return new ArrayList<String>();
        }
        int startIndex = 0;
        int endIndex = obfuscatedSqlFieldsString.length() - 1;
        if (obfuscatedSqlFieldsString.charAt(startIndex) == '\'' && obfuscatedSqlFieldsString.charAt(endIndex) == '\'') {
            obfuscatedSqlFieldsString = obfuscatedSqlFieldsString.substring(1, endIndex);
        }
        String[] obfuscatedSqlFieldsArray = obfuscatedSqlFieldsString.split(",");
        ArrayList<String> obfuscatedSqlFieldsList = new ArrayList<String>();
        for (String obfuscatedSqlField : obfuscatedSqlFieldsArray) {
            if (!this.isUniqueObfuscatedSqlField(obfuscatedSqlField = obfuscatedSqlField.trim(), obfuscatedSqlFieldsList)) continue;
            obfuscatedSqlFieldsList.add(obfuscatedSqlField);
        }
        return obfuscatedSqlFieldsList;
    }

    private List<String> initializeObfuscatedSqlFields(Collection<String> obfuscatedSqlFields) {
        if (obfuscatedSqlFields.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> obfuscatedSqlFieldsList = new ArrayList<String>();
        for (String obfuscatedSqlField : obfuscatedSqlFields) {
            if (!this.isUniqueObfuscatedSqlField(obfuscatedSqlField = obfuscatedSqlField.trim(), obfuscatedSqlFieldsList)) continue;
            obfuscatedSqlFieldsList.add(obfuscatedSqlField);
        }
        return obfuscatedSqlFieldsList;
    }

    private boolean isUniqueObfuscatedSqlField(String obfuscatedSqlFieldCandidate, List<String> obfuscatedSqlFields) {
        for (String obfuscatedSqlField : obfuscatedSqlFields) {
            if (!obfuscatedSqlField.equalsIgnoreCase(obfuscatedSqlFieldCandidate)) continue;
            return false;
        }
        return true;
    }

    private String initializeRecordSql(TransactionTracerConfig parentConfig) {
        String val = this.getProperty(RECORD_SQL, parentConfig.getRecordSql());
        if (val instanceof Boolean) {
            return "off";
        }
        return val.trim().intern();
    }

    public int getMaxSegments() {
        return this.maxSegments;
    }

    public double getStackTraceThresholdInMillis() {
        return this.stackTraceThresholdInMillis;
    }

    public double getExplainThresholdInMillis() {
        return this.explainThresholdInMillis;
    }

    public boolean isExplainEnabled() {
        return this.explainEnabled;
    }

    private boolean isTransactionThresholdApdexF() {
        return this.isTransactionThresholdApdexF;
    }

    public boolean isGCTimeEnabled() {
        return this.gcTimeEnabled;
    }

    public int getMaxStackTraces() {
        return this.maxStackTraces;
    }

    public int getMaxExplainPlans() {
        return this.maxExplainPlans;
    }

    public long getTransactionThreshold(long apdexTInMillis) {
        if (this.isTransactionThresholdApdexF) {
            return apdexTInMillis * 4L;
        }
        return this.transactionThreshold;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getInsertSqlMaxLength() {
        return this.insertSqlMaxLength;
    }

    public String getRecordSql() {
        return this.recordSql;
    }

    public boolean isLogSql() {
        return this.logSql;
    }

    public List<String> getObfuscatedSqlFields() {
        return this.obfuscatedSqlFields;
    }
}

