/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TracedError
implements Comparable<TracedError>,
JSONStreamAware {
    private final String path;
    private final long timestamp;
    private final Map errorParameters;
    private final String requestUri;
    private final String appName;

    public TracedError(String appName, String frontendMetricName, String requestPath, Map errorParameters, long timestamp) {
        this.appName = appName;
        this.timestamp = timestamp;
        this.errorParameters = errorParameters;
        if (requestPath == null) {
            requestPath = "Unknown";
        }
        this.path = frontendMetricName == null ? "Unknown" : frontendMetricName;
        this.requestUri = requestPath;
    }

    public Map getErrorParameters() {
        return this.errorParameters;
    }

    public abstract String getMessage();

    public abstract String getExceptionClass();

    public long getTimestamp() {
        return this.timestamp / 1000L;
    }

    public String getPath() {
        return this.path;
    }

    public abstract Collection<String> stackTrace();

    public Map<String, Collection<String>> stackTraces() {
        return Collections.emptyMap();
    }

    public Object getParams() {
        String referer;
        Map<String, Object> errorParametersCopy = this.createMap(this.errorParameters);
        Map<String, Object> params = this.createMap();
        params.put("request_uri", this.requestUri);
        Collection<String> stackTrace = this.stackTrace();
        if (stackTrace != null) {
            params.put("stack_trace", stackTrace);
        } else {
            Map<String, Collection<String>> stackTraces = this.stackTraces();
            if (stackTraces != null) {
                params.put("stack_traces", stackTraces);
            }
        }
        Map requestParameters = (Map)errorParametersCopy.remove("request_parameters");
        IAgentConfig config = ServiceFactory.getConfigService().getAgentConfig(this.appName);
        if (requestParameters == null && config.isCaptureParams()) {
            requestParameters = Collections.emptyMap();
        }
        if (requestParameters != null) {
            params.put("request_params", requestParameters);
        }
        if ((referer = (String)errorParametersCopy.remove("request_referer")) != null) {
            params.put("request_referer", referer);
        }
        if (!errorParametersCopy.isEmpty()) {
            params.put("custom_params", errorParametersCopy);
        }
        return params;
    }

    private Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    private Map<String, Object> createMap(Map<String, Object> settings) {
        Map<String, Object> result = this.createMap();
        if (settings == null) {
            return result;
        }
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            this.putOrCreate(entry.getKey(), entry.getValue(), result);
        }
        return result;
    }

    private void putOrCreate(String key, Object val, Map<String, Object> settings) {
        if (val instanceof Map) {
            settings.put(key, this.createMap((Map)val));
        } else {
            settings.put(key, val);
        }
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.getTimestamp(), this.getPath(), this.getMessage(), this.getExceptionClass(), this.getParams()), writer);
    }

    @Override
    public int compareTo(TracedError other) {
        return (int)(this.timestamp - other.timestamp);
    }

    public boolean incrementsErrorMetric() {
        return true;
    }
}

