/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.config.PointCutConfig;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.extension.ExtensionFileTypes;
import com.newrelic.agent.extension.JarExtension;
import com.newrelic.agent.extension.YamlReaderUtility;
import com.newrelic.agent.extension.dom.ExtensionDomParser;
import com.newrelic.agent.extension.jaxb.ExtensionConversionUtility;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.org.yaml.snakeyaml.Loader;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import com.newrelic.org.yaml.snakeyaml.constructor.Constructor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionService
extends AbstractService {
    private final List<ConfigurationConstruct> constructs = new ArrayList<ConfigurationConstruct>();
    private final Map<String, com.newrelic.agent.extension.jaxb.beans.Extension> xmlExtensions = new HashMap<String, com.newrelic.agent.extension.jaxb.beans.Extension>();
    private final Map<String, Extension> ymlExtensions = new HashMap<String, Extension>();
    private Yaml yaml;
    private Collection<JarExtension> jarExtensions;
    private final List<Service> services = new ArrayList<Service>();
    private final List<PointCut> pointCuts = new ArrayList<PointCut>();

    public ExtensionService() {
        super(ExtensionService.class.getSimpleName());
    }

    public final List<PointCut> getPointCuts() {
        return this.pointCuts;
    }

    public void addConstruct(ConfigurationConstruct construct) {
        this.constructs.add(construct);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public final Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.ymlExtensions);
    }

    public Class loadExtensionClass(String className) throws ClassNotFoundException {
        if (this.jarExtensions != null) {
            for (JarExtension ext : this.jarExtensions) {
                try {
                    return ext.getClassloader().loadClass(className);
                }
                catch (Exception ex) {
                }
            }
        }
        throw new ClassNotFoundException("Unable to find class " + className);
    }

    @Override
    protected void doStart() {
        if (this.isEnabled()) {
            ExtensionConstructor constructor = new ExtensionConstructor();
            Loader loader = new Loader(constructor);
            this.yaml = new Yaml(loader);
            this.initializeBuiltInExtensions();
            this.loadExtensionJars();
            this.initializeCustomExtensions();
        }
    }

    private void initializeCustomExtensions() {
        File[] xmlFiles = this.getExtensionFiles(ExtensionFileTypes.XML.getFilter());
        File[] ymlFiles = this.getExtensionFiles(ExtensionFileTypes.YML.getFilter());
        this.getValidXMLExtensions(xmlFiles);
        this.getValidYMLExtensions(ymlFiles);
        this.setXMLPointCuts(this.xmlExtensions.values());
        this.setYMLPointCuts();
        this.xmlExtensions.clear();
    }

    private void getValidXMLExtensions(File[] xmlFiles) {
        if (xmlFiles != null) {
            for (File file : xmlFiles) {
                com.newrelic.agent.extension.jaxb.beans.Extension currentExt = ExtensionDomParser.readFileCatchException(file);
                if (currentExt != null) {
                    String name = currentExt.getName();
                    if (name != null && name.length() != 0) {
                        double version = currentExt.getVersion();
                        this.getLogger().log(Level.FINER, MessageFormat.format("Reading custom extension file {0}", file.getAbsolutePath()));
                        com.newrelic.agent.extension.jaxb.beans.Extension inMapExt = this.xmlExtensions.get(name);
                        if (inMapExt == null) {
                            this.xmlExtensions.put(name, currentExt);
                            this.getLogger().log(Level.FINER, MessageFormat.format("Adding extension with name {1} and version {2} from file {0}", file.getAbsolutePath(), name, Double.valueOf(version).toString()));
                            continue;
                        }
                        if (version > inMapExt.getVersion()) {
                            this.xmlExtensions.put(name, currentExt);
                            this.getLogger().log(Level.FINER, MessageFormat.format("Updating extension with name {1} to version {2} from file {0}", file.getAbsolutePath(), name, Double.valueOf(version).toString()));
                            continue;
                        }
                        this.getLogger().log(Level.FINER, MessageFormat.format("Extension with name {1} and version {2} from file {0} being ignored. Another file with name and version already read in.", file.getAbsolutePath(), name, Double.valueOf(version).toString()));
                        continue;
                    }
                    this.getLogger().log(Level.WARNING, "Not reading in extension because it does not have a name in file " + file.getAbsolutePath());
                    continue;
                }
                this.getLogger().log(Level.WARNING, "Extension in file " + file.getAbsolutePath() + " could not be read in.");
            }
        }
    }

    private void getValidYMLExtensions(File[] ymlFiles) {
        if (ymlFiles != null) {
            for (File file : ymlFiles) {
                this.getLogger().log(Level.FINER, MessageFormat.format("Reading custom extension file {0}", file.getAbsolutePath()));
                Extension currentExt = YamlReaderUtility.readExtension(file, this.yaml, this.getClass().getClassLoader());
                if (currentExt != null) {
                    this.addYmlExtension(currentExt);
                    continue;
                }
                this.getLogger().log(Level.WARNING, "Extension in file " + file.getAbsolutePath() + " could not be read in.");
            }
        }
    }

    protected void addYmlExtension(Extension currentExt) {
        String name = currentExt.getName();
        if (name != null && name.length() != 0) {
            double version = currentExt.getVersionNumber();
            com.newrelic.agent.extension.jaxb.beans.Extension inMapExt = this.xmlExtensions.get(name);
            if (inMapExt == null) {
                Extension inMapYamlExt = this.ymlExtensions.get(name);
                if (inMapYamlExt == null) {
                    this.ymlExtensions.put(name, currentExt);
                    this.getLogger().log(Level.FINER, MessageFormat.format("Adding extension with name {0} and version {1}", name, Double.valueOf(version).toString()));
                } else if (version > inMapYamlExt.getVersionNumber()) {
                    this.ymlExtensions.put(name, currentExt);
                    this.getLogger().log(Level.FINER, MessageFormat.format("Updating extension with name {0} to version {1}", name, Double.valueOf(version).toString()));
                } else {
                    this.getLogger().log(Level.FINER, MessageFormat.format("Additional extension with name {0} and version {1} being ignored. Another file with name and version already read in.", name, Double.valueOf(version).toString()));
                }
            } else {
                this.getLogger().log(Level.INFO, MessageFormat.format("There is already an XML extension with name {0}. The YML config will not be used.", name));
            }
        }
    }

    private void setXMLPointCuts(Collection<com.newrelic.agent.extension.jaxb.beans.Extension> extensions) {
        this.pointCuts.addAll(ExtensionConversionUtility.convertToPointCuts(extensions));
    }

    private void setYMLPointCuts() {
        this.pointCuts.addAll(PointCutConfig.getExtensionPointCuts(this.ymlExtensions.values()));
    }

    private File[] getExtensionFiles(FileFilter filter) {
        File directory = this.getExtensionDirectory();
        if (directory == null) {
            return null;
        }
        return directory.listFiles(filter);
    }

    private File getExtensionDirectory() {
        File configDir;
        IAgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        String configDirName = (String)agentConfig.getProperty("extensions.dir");
        if (configDirName == null) {
            configDirName = ConfigFileHelper.getNewRelicDirectory() + File.separator + "extensions";
        }
        if (!(configDir = new File(configDirName)).exists()) {
            Agent.LOG.log(Level.FINE, "The extension directory " + configDir.getAbsolutePath() + " does not exist.");
            configDir = null;
        } else if (!configDir.isDirectory()) {
            Agent.LOG.log(Level.WARNING, "The extension directory " + configDir.getAbsolutePath() + " is not a directory.");
            configDir = null;
        } else if (!configDir.canRead()) {
            Agent.LOG.log(Level.WARNING, "The extension directory " + configDir.getAbsolutePath() + " is not readable.");
            configDir = null;
        }
        return configDir;
    }

    private void loadExtensionJars() {
        this.jarExtensions = this.loadJarExtensions(this.getExtensionDirectory());
        for (JarExtension extension : this.jarExtensions) {
            this.addJarExtensions(extension);
            for (Class clazz : extension.getClasses()) {
                this.noticeExtensionClass(clazz);
            }
        }
    }

    private void noticeExtensionClass(Class clazz) {
        this.getLogger().finest(MessageFormat.format("Noticed extension class {0}", clazz.getName()));
        if (Service.class.isAssignableFrom(clazz)) {
            try {
                this.addService((Service)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                this.getLogger().severe(MessageFormat.format("Unable to instantiate extension service \"{0}\"", clazz.getName()));
                this.getLogger().log(Level.FINE, "Unable to instantiate service", ex);
            }
        }
    }

    private void addService(Service service) {
        String msg = MessageFormat.format("Noticed extension service \"{0}\"", service.getName());
        this.getLogger().finest(msg);
        if (!service.isEnabled()) {
            return;
        }
        this.services.add(service);
        msg = MessageFormat.format("Starting extension service \"{0}\"", service.getName());
        this.getLogger().finest(msg);
        try {
            service.start();
        }
        catch (Exception e) {
            msg = MessageFormat.format("Unable to start extension service \"{0}\" - {1}", service.getName(), e.toString());
            this.getLogger().severe(msg);
            this.getLogger().log(Level.FINE, msg, e);
        }
    }

    private Collection<JarExtension> loadJarExtensions(File jarDirectory) {
        if (jarDirectory == null) {
            return Collections.emptyList();
        }
        if (jarDirectory.isDirectory()) {
            FileFilter jarFilter = new FileFilter(){

                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    String extension = "";
                    int index = name.lastIndexOf(46);
                    if (index > 0) {
                        extension = name.substring(index, name.length());
                    }
                    return extension.equals(".jar");
                }
            };
            return this.loadJars(jarDirectory.listFiles(jarFilter));
        }
        if (jarDirectory.exists()) {
            return this.loadJars(new File[]{jarDirectory});
        }
        return Collections.emptyList();
    }

    private Collection<JarExtension> loadJars(File[] jarFiles) {
        ArrayList<JarExtension> extensions = new ArrayList<JarExtension>();
        for (File file : jarFiles) {
            try {
                JarExtension ext = new JarExtension(this.getLogger(), this.yaml, file);
                extensions.add(ext);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return Collections.unmodifiableCollection(extensions);
    }

    private void initializeBuiltInExtensions() {
        URL jarUrl = AgentJarHelper.getAgentJarUrl();
        if (jarUrl == null) {
            this.getLogger().log(Level.SEVERE, "Unable to determine the agent jar url");
            return;
        }
        try {
            JarExtension jarExtension = new JarExtension(this.getLogger(), this.yaml, URLDecoder.decode(jarUrl.getFile(), "UTF-8"));
            this.addJarExtensions(jarExtension);
        }
        catch (IOException e) {
            this.getLogger().severe(MessageFormat.format("Unable to read extensions from the agent jar : {0}", e.toString()));
            this.getLogger().log(Level.FINER, "Extensions error", e);
        }
    }

    private void addJarExtensions(JarExtension jarExtension) {
        for (Extension extension : jarExtension.getExtensions().values()) {
            this.addYmlExtension(extension);
        }
    }

    @Override
    protected void doStop() {
        this.ymlExtensions.clear();
        this.pointCuts.clear();
        for (Service service : this.services) {
            try {
                service.stop();
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Unable to stop extension service \"{0}\" - {1}", service.getName(), e.toString());
                Agent.LOG.severe(msg);
                this.getLogger().log(Level.FINE, msg, e);
            }
        }
        this.services.clear();
    }

    private class ExtensionConstructor
    extends Constructor {
        public ExtensionConstructor() {
            for (ConfigurationConstruct construct : ExtensionService.this.constructs) {
                this.yamlConstructors.put(construct.getName(), construct);
            }
        }
    }
}

