/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarExtension {
    private ClassLoader classloader;
    private final String filePath;
    private final IAgentLogger logger;
    private final Map<String, Extension> extensions = new HashMap<String, Extension>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarExtension(IAgentLogger logger, Yaml yaml, File file, ClassLoader classLoader) throws IOException {
        this.classloader = classLoader;
        JarFile jarFile = new JarFile(file);
        this.logger = logger;
        this.filePath = file.getAbsolutePath();
        logger.fine(MessageFormat.format(this.isCoreAgentExtension() ? "Loading built-in agent extensions" : "Loading extension jar \"{0}\"", this.filePath));
        Collection<JarEntry> entries = JarExtension.getExtensions(jarFile);
        for (JarEntry entry : entries) {
            InputStream iStream = null;
            try {
                iStream = jarFile.getInputStream(entry);
                if (iStream != null) {
                    this.readExtension(yaml, entry.getName(), iStream);
                    continue;
                }
                logger.fine(MessageFormat.format("Unable to load extension resource \"{0}\"", entry.getName()));
            }
            finally {
                if (iStream == null) continue;
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public JarExtension(IAgentLogger logger, Yaml yaml, File file) throws IOException {
        this(logger, yaml, file, new URLClassLoader(new URL[]{file.toURI().toURL()}, ClassLoader.getSystemClassLoader()));
    }

    public JarExtension(IAgentLogger logger, Yaml yaml, String fileName) throws IOException {
        this(logger, yaml, new File(fileName), ClassLoader.getSystemClassLoader());
    }

    public boolean isCoreAgentExtension() {
        return this.classloader == ClassLoader.getSystemClassLoader();
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public final Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    void addExtension(Extension extension) {
        Extension existing = this.extensions.get(extension.getName());
        if (existing == null || existing.getVersionNumber() < extension.getVersionNumber()) {
            this.extensions.put(extension.getName(), extension);
        }
    }

    private void readExtension(Yaml yaml, String name, InputStream stream) {
        this.logger.finer(MessageFormat.format("Reading extension file {0}", name));
        if (yaml == null) {
            this.logger.severe("The Yaml parser has not been initialized");
            return;
        }
        try {
            Object config = yaml.load(stream);
            if (config instanceof Map) {
                Extension extension = new Extension(this.classloader, (Map)config);
                this.addExtension(extension);
            } else {
                this.logger.severe(MessageFormat.format("Invalid extension file {0}", name));
            }
        }
        catch (Throwable e) {
            this.logger.severe(MessageFormat.format("Invalid extension file {0} : {1}", name, e.toString()));
            this.logger.finer(MessageFormat.format("Extension error", e));
        }
    }

    private static Collection<JarEntry> getExtensions(JarFile file) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        Pattern pattern = Pattern.compile("^META-INF/extensions/(.*).yml$");
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!pattern.matcher(name).matches()) continue;
            list.add(entry);
        }
        return list;
    }

    public Collection<Class> getClasses() {
        File file = new File(this.filePath);
        if (file.exists()) {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
            ArrayList<Class> classes = new ArrayList<Class>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                String fileName = entry.getName();
                int index = fileName.indexOf(".class");
                fileName = fileName.substring(0, index);
                fileName = fileName.replace('/', '.');
                try {
                    classes.add(this.classloader.loadClass(fileName));
                }
                catch (Exception ex) {}
            }
            return classes;
        }
        return Collections.emptyList();
    }
}

