/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.extension.Extension;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;

final class YamlReaderUtility {
    private YamlReaderUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Extension readExtension(File file, Yaml yaml, ClassLoader loader) {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            Extension extension = YamlReaderUtility.readExtension(file.getName(), fileStream, yaml, loader);
            return extension;
        }
        catch (Exception e) {
            Agent.LOG.severe(MessageFormat.format("Unable to read extension file \"{0}\" - {1}", file.getAbsolutePath(), e.toString()));
            Agent.LOG.finer(MessageFormat.format("Extension error", e));
            Extension extension = null;
            return extension;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Extension readExtension(String name, InputStream stream, Yaml yaml, ClassLoader loader) {
        Agent.LOG.finer(MessageFormat.format("Reading extension file {0}", name));
        if (yaml == null) {
            Agent.LOG.severe("The Yaml parser has not been initialized");
            return null;
        }
        try {
            Object config = yaml.load(stream);
            if (config instanceof Map) {
                return new Extension(loader, (Map)config);
            }
            Agent.LOG.severe(MessageFormat.format("Invalid extension file {0}", name));
            return null;
        }
        catch (Throwable e) {
            Agent.LOG.severe(MessageFormat.format("Invalid extension file {0} : {1}", name, e.toString()));
            Agent.LOG.finer(MessageFormat.format("Extension error", e));
            return null;
        }
    }
}

