/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.instrumentation.AnnotationVisitorWrapper;
import com.newrelic.agent.instrumentation.GenericClassAdapter;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.instrumentation.InvocationHandlerTracingMethodAdapter;
import com.newrelic.agent.instrumentation.TraceAnnotationInfo;
import com.newrelic.agent.instrumentation.annotationmatchers.AnnotationMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.org.objectweb.asm.Label;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTracingMethodAdapter
extends AdviceAdapter {
    private static final String JAVA_LANG_THROWABLE = "java/lang/Throwable";
    private static final boolean sDebugTracers = false;
    protected final String methodName;
    protected final String className;
    protected final String methodDesc;
    private int tracerLocalId;
    private final Label startFinallyLabel = new Label();
    private boolean customTracer = false;
    private final GenericClassAdapter genericClassAdapter;
    private final AnnotationMatcher traceAnnotationMatcher;
    private final AnnotationMatcher ignoreTransactionAnnotationMatcher;
    private final AnnotationMatcher ignoreApdexAnnotationMatcher;
    private boolean ignoreApdex;
    private String invocationHandlerFieldName;
    private boolean ignoreTransaction;
    private final boolean matched;
    private TraceAnnotationInfo traceAnnotationInfo;

    public AbstractTracingMethodAdapter(GenericClassAdapter genericClassAdapter, MethodVisitor mv, int access, String className, Class<?> classBeingRedefined, String methodName, String desc, boolean matched) {
        super(262144, mv, access, methodName, desc);
        this.genericClassAdapter = genericClassAdapter;
        this.methodName = methodName;
        this.className = className;
        this.methodDesc = desc;
        this.matched = matched;
        ConfigService configService = ServiceFactory.getConfigService();
        ClassTransformerConfig classTransformerConfig = configService.getAgentConfig().getClassTransformerConfig();
        this.traceAnnotationMatcher = classTransformerConfig.getTraceAnnotationMatcher();
        this.ignoreTransactionAnnotationMatcher = classTransformerConfig.getIgnoreTransactionAnnotationMatcher();
        this.ignoreApdexAnnotationMatcher = classTransformerConfig.getIgnoreApdexAnnotationMatcher();
    }

    @Override
    public void visitEnd() {
        if (!this.skipTracing()) {
            this.mv.visitAnnotation(Type.getDescriptor(InstrumentedMethod.class), true);
        }
        super.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.ignoreTransactionAnnotationMatcher.matches(desc)) {
            String msg = MessageFormat.format("Found {0} annotation on {1}", "NewRelicIgnoreTransaction", new ClassMethodSignature(this.className, this.methodName, this.methodDesc));
            Agent.LOG.fine(msg);
            this.ignoreTransaction = true;
            return super.visitAnnotation(desc, visible);
        }
        if (this.ignoreApdexAnnotationMatcher.matches(desc)) {
            String msg = MessageFormat.format("Found {0} annotation on {1}", "NewRelicIgnoreApdex", new ClassMethodSignature(this.className, this.methodName, this.methodDesc));
            Agent.LOG.fine(msg);
            this.ignoreApdex = true;
            return super.visitAnnotation(desc, visible);
        }
        boolean isTraceAnnotation = this.traceAnnotationMatcher.matches(desc);
        boolean bl = this.customTracer = this.customTracer || isTraceAnnotation;
        if (isTraceAnnotation) {
            this.traceAnnotationInfo = new TraceAnnotationInfo();
            return new AnnotationVisitorWrapper(super.visitAnnotation(desc, visible)){

                public void visit(String name, Object value) {
                    if ("tracerFactoryName".equals(name)) {
                        ((AbstractTracingMethodAdapter)AbstractTracingMethodAdapter.this).traceAnnotationInfo.tracerFactoryName = value.toString();
                    } else if ("metricName".equals(name)) {
                        ((AbstractTracingMethodAdapter)AbstractTracingMethodAdapter.this).traceAnnotationInfo.metricName = value.toString();
                    } else if ("dispatcher".equals(name)) {
                        ((AbstractTracingMethodAdapter)AbstractTracingMethodAdapter.this).traceAnnotationInfo.dispatcher = Boolean.parseBoolean(value.toString());
                    } else if ("skipTransactionTrace".equals(name)) {
                        ((AbstractTracingMethodAdapter)AbstractTracingMethodAdapter.this).traceAnnotationInfo.skipTransactionTrace = Boolean.parseBoolean(value.toString());
                    }
                    super.visit(name, value);
                }
            };
        }
        return super.visitAnnotation(desc, visible);
    }

    private boolean skipTracing() {
        return !this.customTracer && !this.matched && !this.ignoreApdex && !this.ignoreTransaction;
    }

    protected void systemOutPrint(String message) {
        this.systemPrint(message, false);
    }

    protected void systemPrint(String message, boolean error) {
        super.visitFieldInsn(178, "java/lang/System", error ? "err" : "out", "Ljava/io/PrintStream;");
        super.visitLdcInsn(message);
        super.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    @Override
    protected void onMethodEnter() {
        if (this.skipTracing()) {
            return;
        }
        int methodIndex = this.genericClassAdapter.addInstrumentedMethod(this);
        if (this.genericClassAdapter.useInvocationHandlerFields()) {
            this.setInvocationFieldName(methodIndex);
        }
        try {
            Type tracerType = this.getTracerType();
            this.tracerLocalId = this.newLocal(tracerType);
            this.visitInsn(1);
            this.storeLocal(this.tracerLocalId);
            Label startLabel = new Label();
            Label endLabel = new Label();
            Label exceptionLabel = new Label();
            this.mv.visitTryCatchBlock(startLabel, endLabel, exceptionLabel, JAVA_LANG_THROWABLE);
            this.mv.visitLabel(startLabel);
            this.loadGetTracerArguments();
            this.invokeGetTracer();
            this.storeLocal(this.tracerLocalId);
            this.mv.visitLabel(endLabel);
            Label doneLabel = new Label();
            this.mv.visitJumpInsn(167, doneLabel);
            this.mv.visitLabel(exceptionLabel);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                this.mv.visitMethodInsn(182, JAVA_LANG_THROWABLE, "printStackTrace", "()V");
                this.systemPrint(MessageFormat.format("An error occurred creating a tracer for {0}.{1}{2}", this.className, this.methodName, this.methodDesc), true);
            } else {
                int exceptionVar = this.newLocal(Type.getType(Throwable.class));
                this.visitVarInsn(58, exceptionVar);
            }
            this.mv.visitLabel(doneLabel);
        }
        catch (Throwable e) {
            Agent.LOG.severe(MessageFormat.format("An error occurred transforming {0}.{1}{2} : {3}", this.className, this.methodName, this.methodDesc, e.toString()));
            throw new RuntimeException(e);
        }
    }

    private void setInvocationFieldName(int id) {
        this.invocationHandlerFieldName = AbstractTracingMethodAdapter.getInvocationHandlerFieldName(id);
    }

    static String getInvocationHandlerFieldName(int id) {
        return "__nr__invocation_handler" + id;
    }

    public String getInvocationHandlerFieldName() {
        return this.invocationHandlerFieldName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public boolean isIgnoreApdex() {
        return this.ignoreApdex;
    }

    public boolean isIgnoreTransaction() {
        return this.ignoreTransaction;
    }

    protected abstract Type getTracerType();

    protected abstract void invokeGetTracer();

    protected abstract void loadGetTracerArguments();

    public GenericClassAdapter getGenericClassAdapter() {
        return this.genericClassAdapter;
    }

    protected Runnable loadThisRunnable() {
        final boolean isStatic = (this.methodAccess & 8) != 0;
        return new Runnable(){

            public void run() {
                if (isStatic) {
                    AbstractTracingMethodAdapter.this.visitInsn(1);
                } else {
                    AbstractTracingMethodAdapter.this.loadThis();
                }
            }
        };
    }

    protected void loadObjectArray(Object ... objects) {
        if (objects == null || objects.length == 0) {
            this.visitInsn(1);
            return;
        }
        this.push(objects.length);
        Type objectType = Type.getObjectType("java/lang/Object");
        this.newArray(objectType);
        for (int i = 0; i < objects.length; ++i) {
            this.dup();
            this.push(i);
            if (objects[i] == null) {
                this.visitInsn(1);
            } else if (objects[i] instanceof Runnable) {
                ((Runnable)objects[i]).run();
            } else {
                this.mv.visitLdcInsn(objects[i]);
            }
            this.box(objectType);
            this.arrayStore(objectType);
        }
    }

    @Override
    public void visitCode() {
        super.visitCode();
        super.visitLabel(this.startFinallyLabel);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinallyLabel = new Label();
        super.visitTryCatchBlock(this.startFinallyLabel, endFinallyLabel, endFinallyLabel, null);
        super.visitLabel(endFinallyLabel);
        this.onFinally(191);
        super.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onFinally(opcode);
        }
    }

    protected void onFinally(int opcode) {
        if (this.skipTracing()) {
            return;
        }
        Label end = new Label();
        if (opcode == 191) {
            if ("<init>".equals(this.methodName)) {
                return;
            }
            this.dup();
            int exceptionVar = this.newLocal(Type.getType(Throwable.class));
            this.visitVarInsn(58, exceptionVar);
            this.loadLocal(this.tracerLocalId);
            this.ifNull(end);
            this.loadLocal(this.tracerLocalId);
            this.mv.visitTypeInsn(192, InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE.getInternalName());
            this.invokeTraceFinishWithThrowable(exceptionVar);
        } else {
            Runnable loadReturnValue = opcode == 177 ? new LoadNull() : new StoreReturnValueAndReload(opcode);
            this.loadLocal(this.tracerLocalId);
            this.ifNull(end);
            this.loadLocal(this.tracerLocalId);
            this.invokeTraceFinish(opcode, loadReturnValue);
        }
        this.visitLabel(end);
    }

    protected abstract void invokeTraceFinishWithThrowable(int var1);

    protected abstract void invokeTraceFinish(int var1, Runnable var2);

    public TraceAnnotationInfo getTraceAnnotationInfo() {
        return this.traceAnnotationInfo;
    }

    private final class LoadNull
    implements Runnable {
        private LoadNull() {
        }

        public void run() {
            AbstractTracingMethodAdapter.this.visitInsn(1);
        }
    }

    private final class StoreReturnValueAndReload
    implements Runnable {
        private int returnVar;

        public StoreReturnValueAndReload(int opcode) {
            Type returnType = Type.getReturnType(AbstractTracingMethodAdapter.this.methodDesc);
            if (opcode == 176) {
                AbstractTracingMethodAdapter.this.dup();
            } else {
                if (opcode == 173 || opcode == 175) {
                    AbstractTracingMethodAdapter.this.dup2();
                } else {
                    AbstractTracingMethodAdapter.this.dup();
                }
                if (returnType.equals(Type.INT_TYPE)) {
                    returnType = Type.getType(Integer.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(I)Ljava/lang/Integer;"));
                } else if (returnType.equals(Type.LONG_TYPE)) {
                    returnType = Type.getType(Long.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(J)Ljava/lang/Long;"));
                } else if (returnType.equals(Type.DOUBLE_TYPE)) {
                    returnType = Type.getType(Double.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(D)Ljava/lang/Double;"));
                } else if (returnType.equals(Type.FLOAT_TYPE)) {
                    returnType = Type.getType(Float.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(F)Ljava/lang/Float;"));
                } else if (returnType.equals(Type.BOOLEAN_TYPE)) {
                    returnType = Type.getType(Boolean.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(Z)Ljava/lang/Boolean;"));
                } else if (returnType.equals(Type.BYTE_TYPE)) {
                    returnType = Type.getType(Boolean.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(B)Ljava/lang/Byte;"));
                } else if (returnType.equals(Type.SHORT_TYPE)) {
                    returnType = Type.getType(Short.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(S)Ljava/lang/Short;"));
                } else if (returnType.equals(Type.CHAR_TYPE)) {
                    returnType = Type.getType(Character.class);
                    AbstractTracingMethodAdapter.this.invokeStatic(returnType, new Method("valueOf", "(C)Ljava/lang/Character;"));
                } else {
                    Agent.LOG.severe(MessageFormat.format("Unable to parse the return value for {0}{1}", AbstractTracingMethodAdapter.this.methodName, AbstractTracingMethodAdapter.this.methodDesc));
                    AbstractTracingMethodAdapter.this.pop();
                    AbstractTracingMethodAdapter.this.visitInsn(1);
                }
            }
            this.returnVar = AbstractTracingMethodAdapter.this.newLocal(returnType);
            AbstractTracingMethodAdapter.this.storeLocal(this.returnVar, returnType);
        }

        public void run() {
            AbstractTracingMethodAdapter.this.loadLocal(this.returnVar);
        }
    }
}

