/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.api.agent.NewRelicApiImplementation;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Opcodes;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentApiClassTransformer
implements StartableClassFileTransformer {
    private final ClassTransformer classTransformer;
    private final ClassMatcher classMatcher;
    private final IAgentLogger logger;

    public AgentApiClassTransformer(ClassTransformer classTransformer, ClassMatcher classMatcher) {
        this.classTransformer = classTransformer;
        this.classMatcher = classMatcher;
        this.logger = Agent.LOG.getChildLogger(ClassTransformer.class);
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        instrumentation.addTransformer(this, isRetransformSupported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (this.classMatcher.isMatch(loader, className, null)) {
                byte[] byArray;
                if (this.logger.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Instrumenting \"{0}\" in {1}", className, loader);
                    this.logger.finer(msg);
                }
                String fileName = NewRelicApiImplementation.class.getName().replace('.', '/');
                fileName = fileName + ".class";
                InputStream inStream = ClassLoader.getSystemClassLoader().getResourceAsStream(fileName);
                if (inStream == null) {
                    return classfileBuffer;
                }
                try {
                    ClassReader cr = new ClassReader(inStream);
                    ClassWriter cw = InstrumentationUtils.getClassWriter(cr, loader);
                    cr.accept(new ClassRenamer(cw, className), this.classTransformer.getClassReaderFlags());
                    byArray = cw.toByteArray();
                }
                catch (Exception e) {
                    try {
                        try {
                            String msg = MessageFormat.format("Error instrumenting \"{0}\": {1}", className, e);
                            this.logger.finer(msg);
                        }
                        catch (Throwable throwable) {
                            inStream.close();
                            throw throwable;
                        }
                        inStream.close();
                    }
                    catch (Throwable ex) {}
                }
                inStream.close();
                return byArray;
            }
        }
        finally {
            return classfileBuffer;
        }
        {
        }
    }

    class ClassRenamer
    extends ClassVisitor
    implements Opcodes {
        private Set<String> oldNames;
        private final String newName;

        public ClassRenamer(ClassVisitor cv, String newName) {
            super(262144, cv);
            this.oldNames = new HashSet<String>();
            this.newName = newName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.oldNames.add(name);
            this.cv.visit(version, 1, this.newName, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, this.fix(desc), this.fix(signature), exceptions);
            if (mv != null && (access & 0x400) == 0) {
                mv = new MethodRenamer(mv);
            }
            return mv;
        }

        private String fix(String s) {
            if (s != null) {
                for (String name : this.oldNames) {
                    if (s.indexOf(name) == -1) continue;
                    s = s.replaceAll(name, this.newName);
                }
            }
            return s;
        }

        private class MethodRenamer
        extends MethodVisitor {
            public MethodRenamer(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitTypeInsn(int i, String s) {
                if (ClassRenamer.this.oldNames.contains(s)) {
                    s = ClassRenamer.this.newName;
                }
                this.mv.visitTypeInsn(i, s);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (ClassRenamer.this.oldNames.contains(owner)) {
                    this.mv.visitFieldInsn(opcode, ClassRenamer.this.newName, name, ClassRenamer.this.fix(desc));
                } else {
                    this.mv.visitFieldInsn(opcode, owner, name, ClassRenamer.this.fix(desc));
                }
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (ClassRenamer.this.oldNames.contains(owner)) {
                    this.mv.visitMethodInsn(opcode, ClassRenamer.this.newName, name, ClassRenamer.this.fix(desc));
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, ClassRenamer.this.fix(desc));
                }
            }
        }
    }
}

