/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.instrumentation.AgentApiClassTransformer;
import com.newrelic.agent.instrumentation.ClassLoaderClassTransformer;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.ClassTransformerService;
import com.newrelic.agent.instrumentation.InterfaceImplementationClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMixinClassTransformer;
import com.newrelic.agent.instrumentation.JDBCClassTransformer;
import com.newrelic.agent.instrumentation.NewRelicClassLoaderClassTransformer;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.container.tomcat.CoyoteClassTransformer;
import com.newrelic.agent.instrumentation.pointcuts.container.tomcat.GrizzlyClassTransformer;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionClassTransformer;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;

public class ClassTransformerServiceImpl
extends AbstractService
implements ClassTransformerService {
    private final boolean enabled;
    private volatile ClassTransformer classTransformer;

    public ClassTransformerServiceImpl() throws Exception {
        super(ClassTransformerServiceImpl.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getAgentConfig();
        this.enabled = config.getClassTransformerConfig().getProperty("enabled", true);
    }

    protected void doStart() throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("The class transformer is disabled.  No classes will be instrumented.");
            return;
        }
        InstrumentationProxy instrProxy = ServiceFactory.getAgent().getInstrumentation();
        if (instrProxy == null) {
            this.getLogger().severe("Unable to initialize the class transformer because there is no instrumentation hook");
        } else {
            this.classTransformer = this.startClassTransformer(instrProxy);
        }
    }

    private ClassTransformer startClassTransformer(InstrumentationProxy instrProxy) {
        StartableClassFileTransformer[] classTransformers;
        boolean retransformSupported = this.isRetransformationSupported(instrProxy);
        ClassTransformer classTransformer = new ClassTransformer(instrProxy, retransformSupported);
        for (StartableClassFileTransformer transformer : classTransformers = new StartableClassFileTransformer[]{new AgentApiClassTransformer(classTransformer, ExactClassMatcher.or("com/newrelic/api/agent/NewRelic", "com/newrelic/api/agent/NewRelicInternal")), classTransformer, new NewRelicClassLoaderClassTransformer(classTransformer.getClassReaderFlags()), new CoyoteClassTransformer(classTransformer.getClassReaderFlags()), new GrizzlyClassTransformer(classTransformer.getClassReaderFlags()), new InterfaceMixinClassTransformer(classTransformer.getClassReaderFlags()), new JDBCClassTransformer(classTransformer), new ConnectionClassTransformer(classTransformer), new ClassLoaderClassTransformer(classTransformer.getClassReaderFlags())}) {
            transformer.start(instrProxy, retransformSupported);
        }
        for (StartableClassFileTransformer transformer : InterfaceImplementationClassTransformer.getClassTransformers(classTransformer)) {
            transformer.start(instrProxy, retransformSupported);
        }
        return classTransformer;
    }

    private boolean isRetransformationSupported(InstrumentationProxy instrProxy) {
        AgentConfig config = ServiceFactory.getConfigService().getAgentConfig();
        Boolean enableRetransform = (Boolean)config.getProperty("enable_class_retransformation");
        if (enableRetransform != null) {
            return enableRetransform;
        }
        try {
            return instrProxy.isRetransformClassesSupported();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unexpected error asking current JVM configuration if it supports retransformation of classes: {0}", e);
            this.getLogger().warning(msg);
            return false;
        }
    }

    protected void doStop() throws Exception {
        if (this.classTransformer != null) {
            this.classTransformer.shutdown();
            InstrumentationProxy instrProxy = ServiceFactory.getAgent().getInstrumentation();
            if (instrProxy != null) {
                instrProxy.removeTransformer(this.classTransformer);
            }
        }
    }

    public ClassTransformer getClassTransformer() {
        return this.classTransformer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

