/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.org.objectweb.asm.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExactMethodMatcher
implements MethodMatcher {
    private final String name;
    private final Set<String> descriptions;

    public ExactMethodMatcher(String name, String description) {
        this(name, new String[]{description});
    }

    public ExactMethodMatcher(String name, Collection<String> descriptions) {
        this.name = name;
        this.descriptions = descriptions.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(descriptions));
    }

    public ExactMethodMatcher(String name, String ... descriptions) {
        this(name, Arrays.asList(descriptions));
    }

    String getName() {
        return this.name;
    }

    Set<String> getDescriptions() {
        return this.descriptions;
    }

    @Override
    public boolean matches(String name, String desc) {
        return this.name.equals(name) && (this.descriptions.isEmpty() || this.descriptions.contains(desc));
    }

    public String toString() {
        return "Match " + this.name + this.descriptions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descriptions == null ? 0 : ((Object)this.descriptions).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExactMethodMatcher other = (ExactMethodMatcher)obj;
        if (this.descriptions == null ? other.descriptions != null : !((Object)this.descriptions).equals(other.descriptions)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void validate() throws InvalidMethodDescriptor {
        boolean valid = true;
        for (String methodDesc : this.descriptions) {
            try {
                Type[] types;
                for (Type t : types = Type.getArgumentTypes(methodDesc)) {
                    if (t != null) continue;
                    valid = false;
                    break;
                }
            }
            catch (Exception e) {
                valid = false;
            }
            if (valid) continue;
            throw new InvalidMethodDescriptor("Invalid method descriptor: " + methodDesc);
        }
    }
}

