/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.extension.jaxb.MethodMapper;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcherUtility;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactParamsMethodMatcher
implements MethodMatcher {
    private final String name;
    private final String parameterDescriptor;

    private ExactParamsMethodMatcher(String pName, String paramDescriptorWithParenthesis) {
        this.name = pName;
        this.parameterDescriptor = paramDescriptorWithParenthesis;
    }

    public static ExactParamsMethodMatcher createExactParamsMethodMatcher(String methodName, String inputDescriptor, String className, Map<String, MethodMapper> previous) throws RuntimeException {
        if (methodName == null) {
            throw new RuntimeException("Method name can not be null or empty.");
        }
        String methodNameTrimmed = methodName.trim();
        if (methodNameTrimmed.length() == 0) {
            throw new RuntimeException("Method name can not be null or empty.");
        }
        if (inputDescriptor == null) {
            throw new RuntimeException("Parameter descriptor can not be null or empty.");
        }
        String inputDescriptorTrimmed = inputDescriptor.trim();
        if (inputDescriptorTrimmed.length() == 0) {
            throw new RuntimeException("Parameter descriptor can not be null or empty.");
        }
        if (MethodMatcherUtility.isDuplicateMethod(className, methodNameTrimmed, inputDescriptorTrimmed, previous)) {
            throw new RuntimeException("Method " + methodNameTrimmed + " has already be added to a point cut and will " + "not be added again.");
        }
        return new ExactParamsMethodMatcher(methodNameTrimmed, inputDescriptorTrimmed);
    }

    @Override
    public boolean matches(String pName, String pDesc) {
        return this.name.equals(pName) && pDesc != null && pDesc.startsWith(this.parameterDescriptor);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameterDescriptor == null ? 0 : this.parameterDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExactParamsMethodMatcher other = (ExactParamsMethodMatcher)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parameterDescriptor == null ? other.parameterDescriptor != null : !this.parameterDescriptor.equals(other.parameterDescriptor));
    }

    public String toString() {
        return "ExactParamsMethodMatcher(" + this.name + ", " + this.parameterDescriptor + ")";
    }
}

