/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class HttpClient4PointCut
extends HttpCommonsPointCut {
    private static final String UNKNOWN_HOST_NAME = "Unknown";
    private static final String ABSTRACT_HTTP_CLIENT_CLASS_NAME = "org/apache/http/impl/client/AbstractHttpClient";
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String EXECUTE_METHOD_DESC = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;";
    private static final String GET_HOSTNAME_METHOD_NAME = "getHostName";
    private final IAgentLogger logger = Agent.LOG.getChildLogger(this.getClass());

    public HttpClient4PointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpClient4PointCut.class, (ClassMatcher)new ExactClassMatcher(ABSTRACT_HTTP_CLIENT_CLASS_NAME), (MethodMatcher)new ExactMethodMatcher(EXECUTE_METHOD_NAME, EXECUTE_METHOD_DESC));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpClient, Object[] args) {
        String host = UNKNOWN_HOST_NAME;
        try {
            Object httpHost = args[0];
            if (httpHost != null) {
                host = this.getHost(httpHost);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Instrumentation error invoking {0} in {1}: {2}", sig, this.getClass().getName(), t);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, msg, t);
            }
            this.logger.log(Level.FINE, msg);
        }
        return super.getTracer(transaction, sig, httpClient, host);
    }

    private String getHost(Object httpHost) throws Exception {
        if (httpHost instanceof HttpHost) {
            return ((HttpHost)httpHost).getHostName();
        }
        Method getHost = httpHost.getClass().getMethod(GET_HOSTNAME_METHOD_NAME, new Class[0]);
        return (String)getHost.invoke(httpHost, new Object[0]);
    }

    @InterfaceMapper(originalInterfaceName="org/apache/http/HttpMessage", className={"org/apache/http/message/AbstractHttpMessage"})
    public static interface HttpMessageExtension {
        @MethodMapper(originalMethodName="getFirstHeader", originalDescriptor="(Ljava/lang/String;)Lorg/apache/http/Header;", invokeInterface=false)
        public Object _nr_getFirstHeader(String var1);
    }

    @InterfaceMixin(originalClassName={"org/apache/http/HttpHost"})
    public static interface HttpHost {
        public String getHostName();
    }
}

