/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.commons.Header;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpClient4PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.NameValuePair;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentPointCut;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Method;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpCommonsPointCut
extends ExternalComponentPointCut {
    public HttpCommonsPointCut(Class<? extends HttpCommonsPointCut> pointCutClass, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(new PointCutConfiguration(pointCutClass), classMatcher, methodMatcher);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host) {
        return new HttpCommonsTracer(this, transaction, sig, object, host, "CommonsHttp");
    }

    @InterfaceMixin(originalClassName={"org/apache/http/StatusLine"})
    public static interface StatusLine {
        public int getStatusCode();
    }

    @InterfaceMapper(originalInterfaceName="org/apache/http/message/BasicHttpResponse", className={"org/apache/http/message/BasicHttpResponse"})
    public static interface BasicHttpResponseExtension {
        @MethodMapper(originalMethodName="getStatusLine", originalDescriptor="()Lorg/apache/http/StatusLine;", invokeInterface=false)
        public Object _nr_getStatusLine();
    }

    final class HttpCommonsTracer
    extends ExternalComponentTracer
    implements IOTracer {
        private HttpCommonsTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, String host, String library) {
            super(transaction, sig, object, host, library);
        }

        protected void recordResponseStatusCode(Object response) {
            try {
                if (response instanceof BasicHttpResponseExtension) {
                    Object statusLine = ((BasicHttpResponseExtension)response)._nr_getStatusLine();
                    this.setResponseStatusCode(((StatusLine)statusLine).getStatusCode());
                }
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINEST, "An error occurred fetching the response status code", t);
            }
        }

        protected String getHeaderValue(Object returnValue, String name) {
            if (returnValue instanceof HttpClient4PointCut.HttpMessageExtension) {
                HttpClient4PointCut.HttpMessageExtension response = (HttpClient4PointCut.HttpMessageExtension)returnValue;
                Object header = response._nr_getFirstHeader(name);
                return header == null ? null : this.getHeaderValue(header);
            }
            Object invocationTarget = this.getInvocationTarget();
            try {
                Method method = invocationTarget.getClass().getMethod("getResponseHeader", String.class);
                Object header = method.invoke(invocationTarget, name);
                if (header != null) {
                    return header instanceof NameValuePair ? ((NameValuePair)header).getValue() : header.toString();
                }
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINEST, "Error getting response header", t);
            }
            return null;
        }

        private String getHeaderValue(Object header) {
            if (header == null) {
                return null;
            }
            if (header instanceof Header) {
                return ((Header)header).getValue();
            }
            return header.toString();
        }
    }
}

