/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.NameValuePair;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.MethodCache;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class HttpMethodBasePointCut
extends HttpCommonsPointCut {
    private static final String HTTPCONNECTION_CLASS_NAME = "com/newrelic/org/apache/commons/httpclient/HttpConnection";
    private static final String GET_HOST_METHOD_NAME = "getHost";
    private static final String GET_HOST_METHOD_DESC = "()V";
    private static final String UNKNOWN_HOST_NAME = "Unknown";
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String EXECUTE_METHOD_DESC = "(Lorg/apache/commons/httpclient/HttpState;Lorg/apache/commons/httpclient/HttpConnection;)I";
    private static final String GET_RESPONSE_BODY_NAME = "getResponseBody";
    private static final String GET_RESPONSE_BODY_DESC_1 = "()[B";
    private static final String GET_RESPONSE_BODY_DESC_2 = "(I)[B";
    private static final String RELEASE_CONNECTION_NAME = "releaseConnection";
    private static final String RELEASE_CONNECTION_DESC = "()V";
    protected static final String HTTP_METHOD_BASE_CLASS_NAME_MATCH = "com/newrelic/org/apache/commons/httpclient/HttpMethodBase";
    private final MethodCache getHostMethodCache = ServiceFactory.getCacheService().getMethodCache("com/newrelic/org/apache/commons/httpclient/HttpConnection", "getHost", "()V");

    public HttpMethodBasePointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpMethodBasePointCut.class, (ClassMatcher)new ExactClassMatcher(HTTP_METHOD_BASE_CLASS_NAME_MATCH), OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(EXECUTE_METHOD_NAME, EXECUTE_METHOD_DESC), new ExactMethodMatcher(GET_RESPONSE_BODY_NAME, GET_RESPONSE_BODY_DESC_1), new ExactMethodMatcher(GET_RESPONSE_BODY_NAME, GET_RESPONSE_BODY_DESC_2), new ExactMethodMatcher(RELEASE_CONNECTION_NAME, "()V")));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpMethod, Object[] args) {
        String host = UNKNOWN_HOST_NAME;
        try {
            Object header;
            if (sig.getMethodName() == EXECUTE_METHOD_NAME) {
                Object httpConnection = args[1];
                if (httpConnection != null) {
                    host = this.getHost(httpConnection);
                }
            } else if ((sig.getMethodName() == GET_RESPONSE_BODY_NAME || sig.getMethodName() == RELEASE_CONNECTION_NAME) && (header = ((HttpMethodExtension)httpMethod)._nr_getRequestHeader("host")) != null) {
                host = ((NameValuePair)header).getValue();
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Instrumentation error invoking {0} in {1}: {2}", sig, this.getClass().getName(), t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, t);
            }
            Agent.LOG.finer(msg);
        }
        return super.getTracer(transaction, sig, httpMethod, host);
    }

    private String getHost(Object httpConnection) throws Exception {
        Method getHost = this.getHostMethodCache.getDeclaredMethod(httpConnection.getClass());
        return (String)getHost.invoke(httpConnection, new Object[0]);
    }

    @InterfaceMapper(originalInterfaceName="com/newrelic/org/apache/commons/httpclient/HttpMethod", className={"com/newrelic/org/apache/commons/httpclient/HttpMethodBase"})
    public static interface HttpMethodExtension {
        @MethodMapper(originalMethodName="getRequestHeader", originalDescriptor="(Ljava/lang/String;)Lorg/apache/commons/httpclient/Header;", invokeInterface=false)
        public Object _nr_getRequestHeader(String var1);
    }
}

