/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.coldfusion;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.DefaultPointCut;
import com.newrelic.agent.instrumentation.FieldAccessor;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.coldfusion.JRunDelegatingServletHttpRequest;
import com.newrelic.agent.instrumentation.pointcuts.container.coldfusion.JRunDelegatingServletHttpResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.RequestDispatcherTracerFactory;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class ColdFusionDispatcherPointCut
extends DefaultPointCut {
    private static final String SERVLET_ENGINE_SERVICE_NAME = "jrun/servlet/ServletEngineService";
    private static final String DISPATCH_METHOD_NAME = "dispatch";
    private static final String DISPATCH_METHOD_DESC = "(Ljrun/servlet/ServletConnection;)V";

    public ColdFusionDispatcherPointCut(ClassTransformer classTransformer) {
        super(ColdFusionDispatcherPointCut.createPointCutConfig(), ColdFusionDispatcherPointCut.createTracerFactory(), ColdFusionDispatcherPointCut.createClassMatcher(), ColdFusionDispatcherPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(ColdFusionDispatcherPointCut.class);
    }

    private static TracerFactory createTracerFactory() {
        return new DispatcherTracerFactory();
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(SERVLET_ENGINE_SERVICE_NAME);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(DISPATCH_METHOD_NAME, DISPATCH_METHOD_DESC);
    }

    @InterfaceMixin(originalClassName={"jrun/servlet/ServletConnection"})
    public static interface JRunServletConnection {
        @FieldAccessor(fieldName="status", existingField=true)
        public int _nr_getResponseStatus();

        @FieldAccessor(fieldName="requestWrapper", fieldDesc="Ljrun/servlet/JRunRequest;", existingField=true)
        public Object _nr_getRequest();

        @FieldAccessor(fieldName="responseWrapper", fieldDesc="Ljrun/servlet/JRunResponse;", existingField=true)
        public Object _nr_getResponse();
    }

    private static class DispatcherTracerFactory
    extends RequestDispatcherTracerFactory {
        private DispatcherTracerFactory() {
        }

        protected Tracer getTracerImpl(Transaction tx, ClassMethodSignature sig, Object engineService, Object[] args) throws Exception {
            try {
                JRunServletConnection servletConnection = null;
                if (!(args[0] instanceof JRunServletConnection)) {
                    return null;
                }
                servletConnection = (JRunServletConnection)args[0];
                HttpRequest httpRequest = this.createHttpRequest(servletConnection);
                HttpResponse httpResponse = this.createHttpResponse(servletConnection);
                return new BasicRequestDispatcherTracer(tx, sig, engineService, httpRequest, httpResponse);
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Unable to create JRun dispatcher tracer: {0}", e);
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, e);
                } else {
                    Agent.LOG.fine(msg);
                }
                return null;
            }
        }

        private HttpRequest createHttpRequest(JRunServletConnection servletConnection) {
            return JRunDelegatingServletHttpRequest.create(servletConnection);
        }

        private HttpResponse createHttpResponse(JRunServletConnection servletConnection) {
            return JRunDelegatingServletHttpResponse.create(servletConnection);
        }
    }
}

