/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettySuspendContinuationTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import java.text.MessageFormat;

@PointCut
public class JettyContinuationPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = JettyContinuationPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String CONTINUATION_INTERFACE = "org/eclipse/jetty/continuation/Continuation";
    private static final String CONTINUATION_INTERFACE_JETTY_6 = "org/mortbay/util/ajax/Continuation";
    private static final String COMPLETE_METHOD_NAME = "complete";
    private static final String SUSPEND_METHOD_NAME = "suspend";
    private static final String COMPLETE_METHOD_DESC = "()V";
    private static final String SUSPEND_METHOD_DESC = "()V";
    private static final String SUSPEND_METHOD_DESC_JETTY_6 = "(J)Z";
    private static final MetricNameFormat SUSPEND_FORMAT = new SimpleMetricNameFormat("Continuation.suspend");

    public JettyContinuationPointCut(ClassTransformer ct) {
        super(JettyContinuationPointCut.createPointCutConfig(), JettyContinuationPointCut.createClassMatcher(), JettyContinuationPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, null, true);
    }

    private static ClassMatcher createClassMatcher() {
        return OrClassMatcher.getClassMatcher(new InterfaceMatcher(CONTINUATION_INTERFACE_JETTY_6), new InterfaceMatcher(CONTINUATION_INTERFACE));
    }

    private static MethodMatcher createMethodMatcher() {
        return OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(SUSPEND_METHOD_NAME, "()V", SUSPEND_METHOD_DESC_JETTY_6), new ExactMethodMatcher(COMPLETE_METHOD_NAME, "()V"));
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object obj, Object[] args) {
        if (SUSPEND_METHOD_NAME == sig.getMethodName()) {
            return this.getSuspendTracer(tx, sig, obj, args);
        }
        return this.getCompleteTracer(tx, sig, obj, args);
    }

    private Tracer getSuspendTracer(Transaction tx, ClassMethodSignature sig, Object obj, Object[] args) {
        return new JettySuspendContinuationTracer(tx, sig, obj, SUSPEND_FORMAT);
    }

    private Tracer getCompleteTracer(Transaction tx, ClassMethodSignature sig, Object obj, Object[] args) {
        AsyncContextNr asyncContext = null;
        if (obj instanceof AsyncContextNr) {
            asyncContext = (AsyncContextNr)obj;
        }
        if (asyncContext == null) {
            String msg = MessageFormat.format("Continuation {0} is not an instance of {1}", obj.getClass().getName(), AsyncContextNr.class.getName());
            Agent.LOG.finest(msg);
            return null;
        }
        Transaction asyncTx = (Transaction)asyncContext._nr_getTransaction();
        if (asyncTx == null) {
            return null;
        }
        asyncTx.getTransactionState().complete();
        return null;
    }
}

