/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyDelegatingServletHttpRequest;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.AsyncDispatcherTracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;

public class JettyDispatcherTracerFactory
extends AsyncDispatcherTracerFactory {
    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object server, Object[] args) {
        DispatcherTracer rootTracer = tx.getRootTracer();
        if (rootTracer != null) {
            return null;
        }
        Object connection = args[0];
        HttpRequest request = this.getRequest(connection);
        AsyncContextNr asyncContext = this.getAsyncContext(request);
        this.resumeSavedTransaction(asyncContext);
        HttpResponse response = this.getResponse(connection);
        return new BasicRequestDispatcherTracer(tx, sig, server, request, response);
    }

    private HttpResponse getResponse(Object connection) {
        Object response = null;
        if (connection instanceof IHttpConnection) {
            response = ((IHttpConnection)connection)._nr_getResponse();
        } else {
            try {
                response = connection.getClass().getMethod("getResponse", new Class[0]).invoke(connection, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return JettyResponse.getJettyResponse(response);
    }

    private HttpRequest getRequest(Object connection) {
        HttpServletRequest httpServletRequest = null;
        if (connection instanceof IHttpConnection) {
            httpServletRequest = (HttpServletRequest)((IHttpConnection)connection)._nr_getRequest();
        } else {
            try {
                httpServletRequest = (HttpServletRequest)connection.getClass().getMethod("getRequest", new Class[0]).invoke(connection, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return JettyDelegatingServletHttpRequest.create(httpServletRequest);
    }

    @InterfaceMapper(originalInterfaceName="org/eclipse/jetty/io/Connection", className={"org/eclipse/jetty/server/HttpConnection", "org/eclipse/jetty/server/AbstractHttpConnection"})
    public static interface EclipseHttpConnection
    extends IHttpConnection {
        @MethodMapper(invokeInterface=false, originalMethodName="getRequest", originalDescriptor="()Lorg/eclipse/jetty/server/Request;")
        public Object _nr_getRequest();

        @MethodMapper(invokeInterface=false, originalMethodName="getResponse", originalDescriptor="()Lorg/eclipse/jetty/server/Response;")
        public Object _nr_getResponse();
    }

    @InterfaceMapper(originalInterfaceName="org/mortbay/jetty/HttpConnection")
    public static interface HttpConnection
    extends IHttpConnection {
        @MethodMapper(invokeInterface=false, originalMethodName="getRequest", originalDescriptor="()Lorg/mortbay/jetty/Request;")
        public Object _nr_getRequest();

        @MethodMapper(invokeInterface=false, originalMethodName="getResponse", originalDescriptor="()Lorg/mortbay/jetty/Response;")
        public Object _nr_getResponse();
    }

    public static interface IHttpConnection {
        public Object _nr_getRequest();

        public Object _nr_getResponse();
    }
}

