/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JettySampler
implements MetricSampler {
    private final Object server;

    public JettySampler(Object server) throws Exception {
        this.server = server;
        this.enableConnectorStats();
        this.getVersionFromServer(server);
        try {
            Object port;
            Object[] serverConnectors = this.getServerConnectors();
            if (serverConnectors.length > 0 && (port = this.getConnectorClass().getMethod("getPort", new Class[0]).invoke(serverConnectors[0], new Object[0])) instanceof Integer) {
                ServiceFactory.getRPMService().setApplicationServerPort((Integer)port);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to record Jetty server port: {0}", e);
            Agent.LOG.fine(msg);
        }
    }

    protected void getVersionFromServer(Object server) {
        try {
            String version = (String)server.getClass().getMethod("getVersion", new Class[0]).invoke(server, new Object[0]);
            ServiceFactory.getEnvironmentService().getEnvironment().setDispatcherVersion(version);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to record Jetty version: {0}", e);
            Agent.LOG.fine(msg);
        }
    }

    protected void enableConnectorStats() throws Exception {
        Method setStatsOn = this.getConnectorClass().getMethod("setStatsOn", Boolean.TYPE);
        for (Object connector : this.getServerConnectors()) {
            setStatsOn.invoke(connector, true);
        }
    }

    protected final Object getServer() {
        return this.server;
    }

    @Override
    public void sample(StatsEngine statsEngine) {
        block7: {
            try {
                double busyThreads;
                double totalThreads;
                Object[] connectors;
                int acceptorThreadCount = 0;
                for (Object connector : connectors = this.getServerConnectors()) {
                    acceptorThreadCount += ((Number)connector.getClass().getMethod("getAcceptors", new Class[0]).invoke(connector, new Object[0])).intValue();
                }
                Object threadPool = this.server.getClass().getMethod("getThreadPool", new Class[0]).invoke(this.server, new Object[0]);
                if (threadPool == null) break block7;
                String name = threadPool.getClass().getSimpleName();
                if (threadPool instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor executor = (ThreadPoolExecutor)threadPool;
                    totalThreads = executor.getMaximumPoolSize();
                    busyThreads = executor.getActiveCount();
                } else {
                    Number maxThreadCount;
                    Number threadCount = (Number)threadPool.getClass().getMethod("getThreads", new Class[0]).invoke(threadPool, new Object[0]);
                    Number idleCount = (Number)threadPool.getClass().getMethod("getIdleThreads", new Class[0]).invoke(threadPool, new Object[0]);
                    try {
                        maxThreadCount = (Number)threadPool.getClass().getMethod("getMaxThreads", new Class[0]).invoke(threadPool, new Object[0]);
                    }
                    catch (NoSuchMethodException drop) {
                        maxThreadCount = threadCount;
                    }
                    totalThreads = maxThreadCount.doubleValue();
                    busyThreads = threadCount.doubleValue() - idleCount.doubleValue();
                }
                String metricName = MessageFormat.format("RequestThreads/{0}/total", name);
                float metricValue = Double.valueOf(totalThreads -= (double)acceptorThreadCount).floatValue();
                statsEngine.getStats(metricName).recordDataPoint(metricValue);
                metricName = MessageFormat.format("RequestThreads/{0}/busy", name);
                metricValue = Double.valueOf(busyThreads -= (double)acceptorThreadCount).floatValue();
                statsEngine.getStats(metricName).recordDataPoint(metricValue);
                metricName = "Instance/Busy";
                metricValue = Double.valueOf(busyThreads / totalThreads).floatValue();
                statsEngine.getStats(metricName).recordDataPoint(metricValue);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("Unable to sample Jetty system: {0}", t);
                Agent.LOG.fine(msg);
            }
        }
    }

    protected abstract Class<?> getConnectorClass() throws ClassNotFoundException;

    protected String getConnectorsMethodName() {
        return "getConnectors";
    }

    private Object[] getServerConnectors() throws Exception {
        return (Object[])this.server.getClass().getMethod(this.getConnectorsMethodName(), new Class[0]).invoke(this.server, new Object[0]);
    }
}

