/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.resin;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class PortPointCut
extends TracerFactoryPointCut {
    private static final String PORT_CLASS_INTERNAL_NAME = "com/caucho/server/port/Port";

    public PortPointCut(ClassTransformer classTransformer) {
        super(PortPointCut.class, (ClassMatcher)new ExactClassMatcher(PORT_CLASS_INTERNAL_NAME), PortPointCut.createExactMethodMatcher("run", "()V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object port, Object[] args) {
        try {
            Class<?> portClass = port.getClass();
            if (portClass.getName().equals(PORT_CLASS_INTERNAL_NAME.replace('/', '.'))) {
                int portNum = (Integer)portClass.getMethod("getPort", new Class[0]).invoke(port, new Object[0]);
                ServiceFactory.getRPMService().setApplicationServerPort(portNum);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "Unable to get Resin port number", e);
        }
        return null;
    }
}

