/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.resin;

import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.DefaultPointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.resin.ResinServletTracerFactory;
import com.newrelic.agent.tracers.TracerFactory;

@PointCut
public class ServletInvocationPointCut
extends DefaultPointCut {
    private static final String SERVLET_INVOCATION_CLASS_NAME = "com/caucho/server/dispatch/ServletInvocation";
    private static final String SERVICE_METHOD_NAME = "service";
    private static final String SERVICE_METHOD_DESC = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)V";

    public ServletInvocationPointCut(ClassTransformer classTransformer) {
        super(ServletInvocationPointCut.createPointCutConfig(), ServletInvocationPointCut.createTracerFactory(), ServletInvocationPointCut.createClassMatcher(), ServletInvocationPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(ServletInvocationPointCut.class);
    }

    private static TracerFactory createTracerFactory() {
        return new ResinServletTracerFactory();
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(SERVLET_INVOCATION_CLASS_NAME);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(SERVICE_METHOD_NAME, SERVICE_METHOD_DESC);
    }
}

