/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.resin;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.Invoker;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@PointCut
public class WatchdogPointCut
extends TracerFactoryPointCut {
    private static final String V3_1_0_CONSTRUCTOR_DESC = "(Lcom/caucho/boot/ClusterConfig;)V";

    public WatchdogPointCut(ClassTransformer classTransformer) {
        super(WatchdogPointCut.class, ExactClassMatcher.or("com/caucho/boot/Watchdog", "com/caucho/boot/ResinWatchdog"), (MethodMatcher)new ExactMethodMatcher("<init>", "(Lcom/caucho/boot/WatchdogConfig;)V", "(Ljava/lang/String;Lcom/caucho/boot/WatchdogArgs;)V", V3_1_0_CONSTRUCTOR_DESC));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, final Object watchdog, Object[] args) {
        final ArrayList<String> argsList = new ArrayList<String>();
        final boolean oldVersion = V3_1_0_CONSTRUCTOR_DESC == sig.getMethodDesc();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("java.lang:type=Runtime");
            String[] jvmArgs = (String[])mbeanServer.getAttribute(name, "InputArguments");
            if (jvmArgs != null) {
                Agent.LOG.finer("Java args: " + Arrays.asList(jvmArgs));
                for (String arg : jvmArgs) {
                    if ((!arg.startsWith("-javaagent") || !arg.endsWith("newrelic.jar")) && (!oldVersion || !arg.startsWith("-Dnewrelic"))) continue;
                    argsList.add(arg);
                }
                Agent.LOG.finer("New Relic args: " + argsList);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "An error occurred extracting the newrelic javaagent switch", e);
            return null;
        }
        if (argsList.isEmpty()) {
            Agent.LOG.severe("Unable to pick up the newrelic javaagent switch for the Resin Watchdog");
            return null;
        }
        return new MethodExitTracer(sig, transaction){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doFinish(int opcode, Object returnValue) {
                try {
                    Object watchdogConfig = oldVersion ? watchdog : Invoker.invoke(watchdog, watchdog.getClass(), "getConfig", new Object[0]);
                    for (String arg : argsList) {
                        Class<?> configClass = watchdogConfig.getClass();
                        Invoker.invoke(watchdogConfig, configClass, "addJvmArg", arg);
                        try {
                            Method method = configClass.getMethod("addWatchdogArg", String.class);
                            method.setAccessible(true);
                            method.invoke(watchdogConfig, arg);
                        }
                        catch (NoSuchMethodException e) {
                            Invoker.invoke(watchdogConfig, watchdogConfig.getClass(), "addWatchdogJvmArg", arg);
                        }
                    }
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINER, "An error occurred setting the newrelic javaagent switch on the Resin process", t);
                }
            }
        };
    }
}

