/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpResponse;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.HttpServletResponse;

@PointCut
public class PostParseRequestPointCut
extends TracerFactoryPointCut {
    public static final String TOMCAT_INSTRUMENTATION_GROUP_NAME = "tomcat_instrumentation";
    private static final String POINT_CUT_NAME = PostParseRequestPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String COYOTE_ADAPTER_CLASS = "org/apache/catalina/connector/CoyoteAdapter";
    private static final String POST_PARSE_REQUEST_METHOD_NAME = "postParseRequest";
    private static final String POST_PARSE_REQUEST_METHOD_TOMCAT_DESC = "(Lorg/apache/coyote/Request;Lorg/apache/catalina/connector/Request;Lorg/apache/coyote/Response;Lorg/apache/catalina/connector/Response;)Z";
    private static final String POST_PARSE_REQUEST_METHOD_GRIZZLY_DESC = "(Lcom/sun/grizzly/tcp/Request;Lorg/apache/catalina/connector/Request;Lcom/sun/grizzly/tcp/Response;Lorg/apache/catalina/connector/Response;)Z";

    public PostParseRequestPointCut(ClassTransformer classTransformer) {
        super(PostParseRequestPointCut.createPointCutConfig(), PostParseRequestPointCut.createClassMatcher(), PostParseRequestPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, null, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(COYOTE_ADAPTER_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(POST_PARSE_REQUEST_METHOD_NAME, POST_PARSE_REQUEST_METHOD_TOMCAT_DESC, POST_PARSE_REQUEST_METHOD_GRIZZLY_DESC);
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object obj, Object[] args) {
        HttpRequest request = null;
        if (args[1] instanceof HttpServletRequest) {
            HttpServletRequest delegate = (HttpServletRequest)args[1];
            request = DelegatingServletHttpRequest.create(delegate);
            tx.getDispatcher().setRequest(request);
        }
        HttpResponse response = null;
        if (args[3] instanceof HttpServletResponse) {
            HttpServletResponse delegate = (HttpServletResponse)args[3];
            response = DelegatingServletHttpResponse.create(delegate);
            tx.getDispatcher().setResponse(response);
        }
        return null;
    }
}

