/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.tomcat.DelegatingTomcatServletRequest;
import com.newrelic.agent.instrumentation.pointcuts.container.tomcat.TomcatServletRequest;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;

@PointCut
public class TomcatDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    public static final String TOMCAT_INSTRUMENTATION_GROUP_NAME = "tomcat_instrumentation";
    private static final String POINT_CUT_NAME = TomcatDispatcherPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String COYOTE_ADAPTER_CLASS = "org/apache/catalina/connector/CoyoteAdapter";
    private static final String TOMCAT_5_COYOTE_ADAPTER_CLASS = "org/apache/coyote/tomcat5/CoyoteAdapter";
    private static final String SERVICE_METHOD_NAME = "service";
    private static final String SERVICE_METHOD_COYOTE_DESC = "(Lorg/apache/coyote/Request;Lorg/apache/coyote/Response;)V";
    private static final String SERVICE_METHOD_GRIZZLY_DESC = "(Lcom/sun/grizzly/tcp/Request;Lcom/sun/grizzly/tcp/Response;)V";

    public TomcatDispatcherPointCut(ClassTransformer classTransformer) {
        super(TomcatDispatcherPointCut.createPointCutConfig(), TomcatDispatcherPointCut.createClassMatcher(), TomcatDispatcherPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, TOMCAT_INSTRUMENTATION_GROUP_NAME, true);
    }

    private static ClassMatcher createClassMatcher() {
        return ExactClassMatcher.or(TOMCAT_5_COYOTE_ADAPTER_CLASS, COYOTE_ADAPTER_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(SERVICE_METHOD_NAME, SERVICE_METHOD_COYOTE_DESC, SERVICE_METHOD_GRIZZLY_DESC);
    }

    protected HttpRequest getRequest(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        TomcatServletRequest request = (TomcatServletRequest)args[0];
        return DelegatingTomcatServletRequest.create(request);
    }

    protected HttpResponse getResponse(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return (HttpResponse)args[1];
    }

    @InterfaceMapper(originalInterfaceName="com/sun/grizzly/tcp/Response")
    public static interface GrizzlyResponse
    extends HttpResponse {
        @MethodMapper(originalMethodName="getStatus", invokeInterface=false)
        public int _nr_getResponseStatus();

        @MethodMapper(originalMethodName="getMessage", invokeInterface=false)
        public String _nr_getResponseStatusMessage();

        @MethodMapper(originalMethodName="setHeader", invokeInterface=false)
        public void _nr_setHeader(String var1, String var2);

        @MethodMapper(originalMethodName="getContentType", invokeInterface=false)
        public String _nr_getContentType();
    }

    @InterfaceMapper(originalInterfaceName="org/apache/coyote/Response")
    public static interface CoyoteResponse
    extends HttpResponse {
        @MethodMapper(originalMethodName="getStatus", invokeInterface=false)
        public int _nr_getResponseStatus();

        @MethodMapper(originalMethodName="getMessage", invokeInterface=false)
        public String _nr_getResponseStatusMessage();

        @MethodMapper(originalMethodName="setHeader", invokeInterface=false)
        public void _nr_setHeader(String var1, String var2);

        @MethodMapper(originalMethodName="getContentType", invokeInterface=false)
        public String _nr_getContentType();
    }
}

