/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Agent;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.mbeans.MBeanUtils;

public class TomcatSampler
implements MetricSampler {
    public static final String THREAD_POOL_CURR_BUSY_ATTRIBUTE = "currentThreadsBusy";
    public static final String THREAD_POOL_CURR_COUNT_ATTRIBUTE = "currentThreadCount";
    public static final String THREAD_POOL_MAX_THREADS_ATTRIBUTE = "maxThreads";
    public static final String DB_POOL_NUM_ACTIVE_ATTRIBUTE = "numActive";
    public static final String DB_POOL_MAX_ACTIVE_ATTRIBUTE = "maxActive";
    public static final String DB_POOL_DRIVER_CLASS_NAME_ATTRIBUTE = "driverClassName";
    private MBeanServer mbeanServer;
    private String domain;
    private StandardServer server;
    private final List<ObjectName> threadPoolNames;
    private LinkedList<ObjectName> dataSoureNames;

    public TomcatSampler(Object serverObject) throws Exception {
        this.server = (StandardServer)serverObject;
        this.domain = this.server.getDomain();
        this.mbeanServer = MBeanUtils.createServer();
        this.threadPoolNames = new LinkedList<ObjectName>();
        ObjectName serverName = new ObjectName(this.domain + ":type=Server");
        try {
            String serverInfo = (String)this.mbeanServer.getAttribute(serverName, "serverInfo");
            String[] split = serverInfo.split("/");
            if (split.length > 1) {
                String version = split[1];
                ServiceFactory.getEnvironmentService().getEnvironment().setDispatcherVersion(version);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "Unable to get Apache Tomcat version number");
        }
        Set<ObjectInstance> threadPoolMBeans = this.mbeanServer.queryMBeans(new ObjectName(this.domain + ":type=ThreadPool,*"), null);
        for (ObjectInstance instance : threadPoolMBeans) {
            try {
                Object port = this.mbeanServer.getAttribute(instance.getObjectName(), "port");
                if (port == null) continue;
                this.threadPoolNames.add(instance.getObjectName());
            }
            catch (Exception e) {}
        }
        this.dataSoureNames = new LinkedList();
        Set<ObjectInstance> dataSourceMBeans = this.mbeanServer.queryMBeans(new ObjectName(this.domain + ":type=DataSource,*"), null);
        for (ObjectInstance ds : dataSourceMBeans) {
            this.dataSoureNames.add(ds.getObjectName());
        }
    }

    public void sample(StatsEngine statsEngine) {
        block2: {
            try {
                this.recordRequestThreadMetrics(statsEngine);
                this.recordDataSourceMetrics(statsEngine);
            }
            catch (Throwable t) {
                if (!Agent.LOG.isLoggable(Level.FINER)) break block2;
                String msg = MessageFormat.format("Unable to record Tomcat thread pool metrics: {0}", t);
                Agent.LOG.finer(msg);
            }
        }
    }

    private void recordRequestThreadMetrics(StatsEngine statsEngine) throws Exception {
        for (ObjectName tpName : this.threadPoolNames) {
            Integer max = (Integer)this.mbeanServer.getAttribute(tpName, THREAD_POOL_MAX_THREADS_ATTRIBUTE);
            Integer busyCount = (Integer)this.mbeanServer.getAttribute(tpName, THREAD_POOL_CURR_BUSY_ATTRIBUTE);
            Integer currentCount = (Integer)this.mbeanServer.getAttribute(tpName, THREAD_POOL_CURR_COUNT_ATTRIBUTE);
            String threadPoolName = tpName.getKeyProperty("name");
            String metricName = MessageFormat.format("RequestThread/{0}/{1}", threadPoolName, "total");
            float metricValue = currentCount.floatValue();
            statsEngine.getStats(metricName).recordDataPoint(metricValue);
            metricName = MessageFormat.format("RequestThread/{0}/{1}", threadPoolName, "busy");
            metricValue = busyCount.floatValue();
            statsEngine.getStats(metricName).recordDataPoint(metricValue);
            if (max == null || busyCount == null) continue;
            Double busyPercentage = busyCount.doubleValue() / max.doubleValue();
            statsEngine.getStats("Instance/Busy").recordDataPoint(busyPercentage.floatValue());
        }
    }

    private void recordDataSourceMetrics(StatsEngine statsEngine) throws Exception {
        for (ObjectName dsName : this.dataSoureNames) {
            String poolName = Strings.unquote(dsName.getKeyProperty("name"));
            String driverName = (String)this.mbeanServer.getAttribute(dsName, DB_POOL_DRIVER_CLASS_NAME_ATTRIBUTE);
            Integer max = (Integer)this.mbeanServer.getAttribute(dsName, DB_POOL_MAX_ACTIVE_ATTRIBUTE);
            Integer num = (Integer)this.mbeanServer.getAttribute(dsName, DB_POOL_NUM_ACTIVE_ATTRIBUTE);
            String metricName = MessageFormat.format("DatabasePool/{0}/{1}/{2}", driverName, poolName, DB_POOL_MAX_ACTIVE_ATTRIBUTE);
            float metricValue = max.floatValue();
            statsEngine.getStats(metricName).recordDataPoint(metricValue);
            metricName = MessageFormat.format("DatabasePool/{0}/{1}/{2}", driverName, poolName, DB_POOL_NUM_ACTIVE_ATTRIBUTE);
            metricValue = num.floatValue();
            statsEngine.getStats(metricName).recordDataPoint(metricValue);
        }
    }
}

