/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.weblogic;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.AbstractHttpResponse;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import java.lang.reflect.Method;

@PointCut
public class WebLogicDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    public WebLogicDispatcherPointCut(ClassTransformer classTransformer) {
        super(WebLogicDispatcherPointCut.class, (ClassMatcher)new ExactClassMatcher("weblogic/servlet/internal/WebAppServletContext"), WebLogicDispatcherPointCut.createExactMethodMatcher("execute", "(Lweblogic/servlet/internal/ServletRequestImpl;Lweblogic/servlet/internal/ServletResponseImpl;)V"));
    }

    protected HttpRequest getRequest(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
        HttpServletRequest servletRequest = (HttpServletRequest)args[0];
        return DelegatingServletHttpRequest.create(servletRequest);
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        Object response = args[1];
        return new AbstractHttpResponse(response){

            public int _nr_getResponseStatus() throws Exception {
                Method method = this.response.getClass().getMethod("getStatus", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke(this.response, new Object[0]);
            }

            public String _nr_getResponseStatusMessage() throws Exception {
                return null;
            }

            public String _nr_getContentType() throws Exception {
                return null;
            }
        };
    }
}

