/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.websphere;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.AbstractHttpResponse;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.logging.Level;

@PointCut
public class WebSphereDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    private static final String WEB_COMMERCE_RESPONSE_CLASS = "com/ibm/commerce/messaging/viewcommands/WCMSResponse";
    private static final String WEB_CONTAINER_CLASS = "com/ibm/ws/webcontainer/WebContainer";
    private static final String HANDLE_REQUEST_METHOD_NAME = "handleRequest";
    private static final String HANDLE_REQUEST_DESC = "(Lcom/ibm/websphere/servlet/request/IRequest;Lcom/ibm/websphere/servlet/response/IResponse;)V";

    public WebSphereDispatcherPointCut(ClassTransformer classTransformer) {
        super(WebSphereDispatcherPointCut.class, WebSphereDispatcherPointCut.createClassMatcher(), WebSphereDispatcherPointCut.createMethodMatcher());
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(WEB_CONTAINER_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(HANDLE_REQUEST_METHOD_NAME, HANDLE_REQUEST_DESC);
    }

    protected HttpRequest getRequest(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        Object request = args[0];
        if (request instanceof WebSphereHttpRequest) {
            Object httpRequest = null;
            try {
                httpRequest = request.getClass().getMethod("getHttpRequest", new Class[0]).invoke(request, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (httpRequest instanceof HttpRequestMessage) {
                return DelegatingWebSphereHttpRequest.create((WebSphereHttpRequest)request, (HttpRequestMessage)httpRequest);
            }
            return DelegatingWebSphereHttpRequest.create((WebSphereHttpRequest)request, null);
        }
        return null;
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        Object response = args[1];
        if (response instanceof WebCommerceHttpResponse) {
            return DelegatingWebCommerceHttpResponse.create((WebCommerceHttpResponse)response);
        }
        return new AbstractHttpResponse(response){

            public int _nr_getResponseStatus() throws Exception {
                Object httpResponse = this.response.getClass().getMethod("getHttpResponse", new Class[0]).invoke(this.response, new Object[0]);
                return (Integer)httpResponse.getClass().getMethod("getStatusCodeAsInt", new Class[0]).invoke(httpResponse, new Object[0]);
            }

            public String _nr_getResponseStatusMessage() throws Exception {
                return null;
            }

            public String _nr_getContentType() throws Exception {
                return null;
            }
        };
    }

    private static class DelegatingWebCommerceHttpResponse
    implements HttpResponse {
        private final WebCommerceHttpResponse delegate;

        private DelegatingWebCommerceHttpResponse(WebCommerceHttpResponse delegate) {
            this.delegate = delegate;
        }

        public int _nr_getResponseStatus() throws Exception {
            return this.delegate.getStatusCode();
        }

        public String _nr_getResponseStatusMessage() throws Exception {
            return this.delegate.getReason();
        }

        public void _nr_setHeader(String name, String value) {
            this.delegate.addHeader(name, value);
        }

        public String _nr_getContentType() throws Exception {
            return null;
        }

        static HttpResponse create(WebCommerceHttpResponse delegate) {
            return new DelegatingWebCommerceHttpResponse(delegate);
        }
    }

    @InterfaceMixin(originalClassName={"com/ibm/commerce/messaging/viewcommands/WCMSResponse"})
    public static interface WebCommerceHttpResponse {
        public int getStatusCode();

        public void addHeader(String var1, String var2);

        public String getReason();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingWebSphereHttpRequest
    implements HttpRequest {
        private final WebSphereHttpRequest delegate;
        private final HttpRequestMessage messageDelegate;

        private DelegatingWebSphereHttpRequest(WebSphereHttpRequest delegate, HttpRequestMessage messageDelegate) {
            this.delegate = delegate;
            this.messageDelegate = messageDelegate;
        }

        @Override
        public Enumeration<?> getParameterNames() {
            return this.messageDelegate == null ? null : this.messageDelegate.getParameterNames();
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.messageDelegate == null ? new String[]{} : this.messageDelegate.getParameterValues(name);
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public String getRequestURI() {
            return this.delegate.getRequestURI();
        }

        @Override
        public String getHeader(String name) {
            return this.delegate.getHeader(name);
        }

        @Override
        public String getRemoteUser() {
            return this.delegate.getRemoteUser();
        }

        @Override
        public boolean isAsyncStarted() {
            return false;
        }

        @Override
        public boolean isAsyncSupported() {
            return false;
        }

        @Override
        public AsyncContextNr getAsyncContextNr() {
            return null;
        }

        @Override
        public String getCookieValue(String name) {
            byte[] bytes = this.delegate.getCookieValue(name);
            if (bytes == null) {
                return null;
            }
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                String msg = MessageFormat.format("WebSphereHttpRequest error getting cookie value for \"{0}\": {1}", name, e);
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.WARNING, msg, e);
                } else {
                    Agent.LOG.warning(msg);
                }
                return null;
            }
        }

        static HttpRequest create(WebSphereHttpRequest delegate, HttpRequestMessage messageDelegate) {
            return new DelegatingWebSphereHttpRequest(delegate, messageDelegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @InterfaceMixin(originalClassName={"com/ibm/wsspi/http/channel/HttpRequestMessage"})
    public static interface HttpRequestMessage {
        public Enumeration<?> getParameterNames();

        public String[] getParameterValues(String var1);
    }

    @InterfaceMixin(originalClassName={"com/ibm/websphere/servlet/request/IRequest"})
    public static interface WebSphereHttpRequest {
        public String getRequestURI();

        public String getHeader(String var1);

        public String getRemoteUser();

        public byte[] getCookieValue(String var1);
    }
}

