/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.database.ParameterizedPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.PreparedStatementExtension;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class ClearPreparedStatementParametersPointCut
extends PointCut
implements EntryInvocationHandler {
    private static final String CLEAR_PARAMETERS_METHOD_NAME = "clearParameters";
    private static final MethodMatcher METHOD_MATCHER = new ExactMethodMatcher("clearParameters", "()V");

    public ClearPreparedStatementParametersPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_parameterized_prepared_statement", null, ServiceFactory.getConfigService().getAgentConfig().isGenericJDBCSupportEnabled()), ParameterizedPreparedStatementPointCut.createClassMatcher(), METHOD_MATCHER);
    }

    public void handleInvocation(ClassMethodSignature sig, Object statement, Object[] args) {
        PreparedStatementExtension preparedStatement;
        Object[] params;
        if (statement instanceof PreparedStatementExtension && (params = (preparedStatement = (PreparedStatementExtension)statement)._nr_getSqlParameters()) != null) {
            for (int i = 0; i < params.length; ++i) {
                params[i] = null;
            }
        }
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }
}

