/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.database.DatabaseVendor;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.instrumentation.pointcuts.database.DatabaseUtils;
import com.newrelic.agent.instrumentation.pointcuts.database.ReflectiveDataSource;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlDriverPointCut;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.org.objectweb.asm.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.sql.DataSource;

@PointCut
public class DataSourcePointCut
extends TracerFactoryPointCut {
    public DataSourcePointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_data_source"), (ClassMatcher)new InterfaceMatcher(Type.getInternalName(DataSource.class)), DataSourcePointCut.createMethodMatcher(new ExactMethodMatcher("getConnection", "()" + Type.getDescriptor(Connection.class)), new ExactMethodMatcher("getConnection", "(Ljava/lang/String;Ljava/lang/String;)" + Type.getDescriptor(Connection.class))));
    }

    private boolean explainsEnabled(Transaction tx) {
        ITransactionTracerConfig ttConfig = tx.getTransactionTracerConfig();
        return ttConfig.isEnabled() && ttConfig.isExplainEnabled();
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object dataSource, Object[] args) {
        DataSource ds;
        Tracer parentTracer = transaction.getLastTracer();
        if (!this.explainsEnabled(transaction) || transaction.isOverTracerSegmentLimit()) {
            ClassMethodSignature parentSig;
            if (parentTracer != null && (parentSig = parentTracer.getClassMethodSignature()).getClassName().equals(sig.getClassName()) && parentSig.getMethodName().equals(sig.getMethodName())) {
                return null;
            }
            ClassMethodMetricNameFormat metricName = new ClassMethodMetricNameFormat(sig, dataSource);
            return new ConnectionTracer(transaction, sig, dataSource, metricName);
        }
        if (parentTracer instanceof DataSourceTracer) {
            return null;
        }
        ClassMethodMetricNameFormat metricName = new ClassMethodMetricNameFormat(sig, dataSource);
        if (dataSource instanceof DataSource) {
            ds = (DataSource)dataSource;
        } else {
            try {
                ds = new ReflectiveDataSource(dataSource);
            }
            catch (ClassNotFoundException e) {
                if (Agent.LOG.isLoggable(Level.SEVERE)) {
                    Agent.LOG.severe(dataSource.getClass().getName() + " does not appear to be an instance of DataSource");
                }
                return new ConnectionTracer(transaction, sig, dataSource, metricName);
            }
        }
        return new DataSourceTracer(transaction, sig, ds, args, metricName);
    }

    private static abstract class AConnectionFactory
    implements ConnectionFactory {
        private String url;
        private final DataSource dataSource;
        private DatabaseVendor databaseVendor = DatabaseVendor.UNKNOWN;

        public AConnectionFactory(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        protected DataSource getDataSource() {
            return this.dataSource;
        }

        public DatabaseVendor getDatabaseVendor() {
            return this.databaseVendor;
        }

        void setDatabaseVendor(DatabaseVendor databaseVendor) {
            this.databaseVendor = databaseVendor;
        }
    }

    private static class DataSourceConnectionFactory
    extends AConnectionFactory {
        private final String password;
        private final String username;

        public DataSourceConnectionFactory(DataSource dataSource, String username, String password) {
            super(dataSource);
            this.username = username;
            this.password = password;
        }

        public Connection getConnection() throws SQLException {
            return this.getDataSource().getConnection(this.username, this.password);
        }
    }

    private static class NoArgsDataSourceConnectionFactory
    extends AConnectionFactory {
        public NoArgsDataSourceConnectionFactory(DataSource dataSource) {
            super(dataSource);
        }

        public Connection getConnection() throws SQLException {
            return this.getDataSource().getConnection();
        }
    }

    private static class DataSourceTracer
    extends ConnectionTracer {
        private AConnectionFactory connectionFactory;

        public DataSourceTracer(Transaction transaction, ClassMethodSignature sig, DataSource dataSource, Object[] args, ClassMethodMetricNameFormat metricName) {
            super(transaction, sig, dataSource, metricName);
            this.connectionFactory = args.length == 2 ? new DataSourceConnectionFactory(dataSource, (String)args[0], (String)args[1]) : new NoArgsDataSourceConnectionFactory(dataSource);
        }

        protected void doFinish(int opcode, Object connection) {
            if (connection != null) {
                DatabaseVendor databaseVendor = DatabaseUtils.getDatabaseVendor((Connection)connection);
                this.connectionFactory.setDatabaseVendor(databaseVendor);
                SqlDriverPointCut.putConnectionFactory(this.transaction, (Connection)connection, this.connectionFactory);
            }
        }
    }

    private static class ConnectionTracer
    extends DefaultTracer
    implements DatabaseTracer {
        public ConnectionTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
            super(transaction, sig, object, metricNameFormatter);
        }

        protected void doRecordMetrics(TransactionStats transactionStats) {
            transactionStats.getUnscopedStats().getResponseTimeStats("Database/getConnection").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            if (this.getThrowable() != null) {
                this.transaction.getTransactionStats().getUnscopedStats().getStats("DatabaseErrors/all").incrementCallCount();
            }
        }
    }
}

