/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.DatabaseVendor;
import com.newrelic.agent.instrumentation.pointcuts.database.DelegatingConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;

public class DatabaseUtils {
    public static Connection getInnerConnection(Connection conn) {
        if (conn instanceof DelegatingConnection) {
            DelegatingConnection delegatingConnection = (DelegatingConnection)((Object)conn);
            Connection connection = delegatingConnection.getInnermostDelegate();
            if (connection != null) {
                return DatabaseUtils.getInnerConnection(connection);
            }
            if (conn instanceof DelegatingConnection.PoolGuardConnectionWrapper && (connection = ((DelegatingConnection.PoolGuardConnectionWrapper)((Object)conn))._nr_getDelegate()) != null) {
                return DatabaseUtils.getInnerConnection(connection);
            }
        }
        return conn;
    }

    public static DatabaseVendor getDatabaseVendor(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData == null) {
                return DatabaseVendor.UNKNOWN;
            }
            String url = metaData.getURL();
            if (url == null) {
                return DatabaseVendor.UNKNOWN;
            }
            return DatabaseVendor.getDatabaseVendor(url);
        }
        catch (SQLException e) {
            Agent.LOG.log(Level.FINER, "Unable to determine database vendor", e);
            return DatabaseVendor.UNKNOWN;
        }
    }
}

