/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.database.DatabaseVendor;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import com.newrelic.agent.tracers.ISqlStatementTracer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.logging.Level;

public class DefaultExplainPlanExecutor
implements ExplainPlanExecutor {
    private ISqlStatementTracer tracer;
    private final String originalSqlStatement;

    public DefaultExplainPlanExecutor(ISqlStatementTracer tracer, String originalSqlStatement) {
        this.originalSqlStatement = originalSqlStatement;
        this.tracer = tracer;
    }

    protected Object[] getExplainPlanFromResultSet(ResultSet rs) throws SQLException {
        int columnCount = rs.getMetaData().getColumnCount();
        if (columnCount > 0) {
            LinkedList explains = new LinkedList();
            while (rs.next()) {
                LinkedList<String> values = new LinkedList<String>();
                for (int i = 1; i <= columnCount; ++i) {
                    Object obj = rs.getObject(i);
                    values.add(obj == null ? "" : obj.toString());
                }
                explains.add(values);
            }
            return new Object[]{explains};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runExplainPlan(DatabaseService databaseService, Connection connection, DatabaseVendor vendor) throws SQLException {
        String sql = this.originalSqlStatement;
        try {
            sql = vendor.getExplainPlanSql(sql);
        }
        catch (SQLException e) {
            this.tracer.setExplainPlan(e.getMessage());
            return;
        }
        Agent.LOG.finer("Running explain: " + sql);
        ResultSet resultSet = null;
        Statement statement = null;
        Object[] explainPlan = null;
        try {
            statement = this.createStatement(connection, sql);
            resultSet = this.executeStatement(statement, sql);
            explainPlan = this.getExplainPlanFromResultSet(resultSet);
        }
        catch (Exception e) {
            explainPlan = new Object[]{"An error occurred running explain plan : " + e.getMessage()};
            Agent.LOG.log(Level.FINER, "explain plan error", e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Unable to close result set", e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Unable to close statement", e);
                }
            }
        }
        if (explainPlan != null) {
            this.tracer.setExplainPlan(explainPlan);
        }
    }

    protected ResultSet executeStatement(Statement statement, String sql) throws SQLException {
        return statement.executeQuery(sql);
    }

    protected Statement createStatement(Connection connection, String sql) throws SQLException {
        return connection.createStatement();
    }
}

