/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultStatementData;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.sql.Statement;
import java.util.ArrayList;

@PointCut
public class SqlStatementPointCut
extends TracerFactoryPointCut {
    static final String MYSQL_STATEMENT_CLASS = "com/mysql/jdbc/Statement";
    public static final String SQL_STATEMENT_CLASS = "java/sql/Statement";
    static final String EXECUTE_METHOD_NAME = "execute";
    static final String EXECUTE_UPDATE_METHOD_NAME = "executeUpdate";
    static final String EXECUTE_QUERY_METHOD_NAME = "executeQuery";
    private static final String EXECUTE_QUERY_METHOD_DESC = "(Ljava/lang/String;)Ljava/sql/ResultSet;";
    private static final MethodMatcher METHOD_MATCHER = OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("execute", "(Ljava/lang/String;)Z", "(Ljava/lang/String;I)Z", "(Ljava/lang/String;[I)Z", "(Ljava/lang/String;[Ljava/lang/String;)Z"), new ExactMethodMatcher("executeUpdate", "(Ljava/lang/String;)I", "(Ljava/lang/String;I)I", "(Ljava/lang/String;[I)I", "(Ljava/lang/String;[Ljava/lang/String;)I"), new ExactMethodMatcher("executeQuery", "(Ljava/lang/String;)Ljava/sql/ResultSet;"));

    public SqlStatementPointCut(ClassTransformer classTransformer) {
        this(ServiceFactory.getConfigService().getAgentConfig());
    }

    private SqlStatementPointCut(AgentConfig config) {
        super(new PointCutConfiguration("jdbc_statement"), SqlStatementPointCut.getClassMatcher(config), METHOD_MATCHER);
    }

    private static ClassMatcher getClassMatcher(AgentConfig agentConfig) {
        ArrayList<ClassMatcher> matchers = new ArrayList<ClassMatcher>(2);
        if (agentConfig.isGenericJDBCSupportEnabled()) {
            matchers.add(new InterfaceMatcher(SQL_STATEMENT_CLASS));
        }
        if (agentConfig.getJDBCSupport().contains("mysql")) {
            matchers.add(new ExactClassMatcher(MYSQL_STATEMENT_CLASS));
        }
        return OrClassMatcher.getClassMatcher(matchers);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
        if (args.length > 0) {
            Tracer parent = transaction.getLastTracer();
            if (parent instanceof SqlStatementTracer) {
                return null;
            }
            DefaultStatementData stmtWrapper = new DefaultStatementData(transaction.getDatabaseStatementParser(), (Statement)statement, (String)args[0]);
            return new SqlStatementTracer(transaction, sig, statement, stmtWrapper);
        }
        return null;
    }
}

