/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class HandlerMethodInvokerPointCut
extends TracerFactoryPointCut {
    private static final String TRANSACTION_NAMING_CONFIG_PARAMETER_NAME = "transaction_naming_scheme";
    private static final String SPRING_FRAMEWORK_CONFIG_PARAMETER_NAME = "spring_framework";
    private static final String CONTROLLER_METHOD_NAMING = "controller_method";
    private static final String VIEW_NAMING = "view";
    private static final String DEFAULT_NAMING_METHOD = "controller_method";
    private final boolean useFullPackageName;
    private final boolean normalizeTransactions;
    private final boolean normalizationDisabled;

    public HandlerMethodInvokerPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("spring_handler_method_invoker"), (ClassMatcher)new ExactClassMatcher("org/springframework/web/bind/annotation/support/HandlerMethodInvoker"), HandlerMethodInvokerPointCut.createExactMethodMatcher("doInvokeMethod", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"));
        AgentConfig config = ServiceFactory.getConfigService().getAgentConfig();
        this.useFullPackageName = HandlerMethodInvokerPointCut.getSpringConfiguration(config).getProperty("use_full_package_name", false);
        this.normalizeTransactions = "controller_method".equals(HandlerMethodInvokerPointCut.getSpringConfiguration(config).getProperty(TRANSACTION_NAMING_CONFIG_PARAMETER_NAME, "controller_method"));
        this.normalizationDisabled = !this.normalizeTransactions && !HandlerMethodInvokerPointCut.useViewNameToNormalize(config);
    }

    private static Config getSpringConfiguration(AgentConfig config) {
        return config.getInstrumentationConfig().getConfig(SPRING_FRAMEWORK_CONFIG_PARAMETER_NAME);
    }

    static boolean useViewNameToNormalize(AgentConfig config) {
        return VIEW_NAMING.equals(HandlerMethodInvokerPointCut.getSpringConfiguration(config).getProperty(TRANSACTION_NAMING_CONFIG_PARAMETER_NAME, "controller_method"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object invoker, final Object[] args) {
        if (this.normalizeTransactions) {
            this.setTransactionName(transaction, args);
        }
        return new DefaultTracer(transaction, sig, invoker, new SimpleMetricNameFormat("Spring/Java/" + args[1].getClass().getName() + '/' + ((Method)args[0]).getName())){

            protected void doFinish(Throwable throwable) {
                if (!HandlerMethodInvokerPointCut.this.normalizationDisabled) {
                    HandlerMethodInvokerPointCut.this.setTransactionName(this.transaction, args);
                }
            }
        };
    }

    private void setTransactionName(Transaction transaction, Object[] args) {
        HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
        if (policy.canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK)) {
            String controller = this.getControllerName(args);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Spring controller", controller);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(transaction, controller, "SpringController", TransactionNamePriority.FRAMEWORK);
        }
    }

    private String getControllerName(Object[] args) {
        Method method = (Method)args[0];
        Object controller = args[1];
        String controllerName = this.useFullPackageName ? controller.getClass().getName() : controller.getClass().getSimpleName();
        return '/' + controllerName + '/' + method.getName();
    }
}

