/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.hibernate;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.CleverClassLoader;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class HibernateStatisticsPointCut
extends TracerFactoryPointCut {
    static final String SESSION_FACTORY_IMPL_CLASS_NAME = "org/hibernate/impl/SessionFactoryImpl";

    public HibernateStatisticsPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(HibernateStatisticsPointCut.class.getName(), "hibernate", false), (ClassMatcher)new ExactClassMatcher(SESSION_FACTORY_IMPL_CLASS_NAME), (MethodMatcher)new ExactMethodMatcher("<init>", "(Lorg/hibernate/cfg/Configuration;Lorg/hibernate/engine/Mapping;Lorg/hibernate/cfg/Settings;Lorg/hibernate/event/EventListeners;Lorg/hibernate/SessionFactoryObserver;)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, final Object sessionFactory, Object[] args) {
        return new MethodExitTracer(sig, transaction){

            @Override
            protected void doFinish(int opcode, Object returnValue) {
                CleverClassLoader cl = new CleverClassLoader(sessionFactory.getClass().getClassLoader());
                try {
                    cl.loadClassSpecial(HibernateStatisticsPointCut.class.getPackage().getName() + ".HibernateStatisticsService");
                    Class samplerClass = cl.loadClassSpecial(HibernateStatisticsPointCut.class.getPackage().getName() + ".StatisticsSampler");
                    this.getConstructor(samplerClass).newInstance(this.transaction.getAgent(), sessionFactory);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Unable to create a Hibernate statistics sampler : {0}", e.toString());
                    Agent.LOG.warning(msg);
                    Agent.LOG.log(Level.FINEST, msg, e);
                }
            }

            private Constructor<?> getConstructor(Class<?> samplerClass) {
                for (Constructor<?> constructor : samplerClass.getConstructors()) {
                    if (constructor.getParameterTypes().length != 2) continue;
                    return constructor;
                }
                return null;
            }
        };
    }
}

