/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import java.net.HttpURLConnection;
import java.net.URL;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class HttpURLConnectionPointCut
extends TracerFactoryPointCut {
    private static final String HTTP_URL_CONNECTION_CLASS_NAME = "java/net/HttpURLConnection";

    public HttpURLConnectionPointCut(ClassTransformer classTransformer) {
        super(HttpURLConnectionPointCut.class, (ClassMatcher)new ChildClassMatcher(HTTP_URL_CONNECTION_CLASS_NAME, false), HttpURLConnectionPointCut.createExactMethodMatcher("getResponseCode", "()I"));
        classTransformer.getClassNameFilter().addIncludeClass(HTTP_URL_CONNECTION_CLASS_NAME);
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformUninstrumentedClasses("java.net.HttpURLConnection");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object connection, Object[] args) {
        String operation;
        String host;
        try {
            URL url = (URL)connection.getClass().getMethod("getURL", new Class[0]).invoke(connection, new Object[0]);
            host = url.getHost();
            operation = url.getPath();
        }
        catch (Throwable e) {
            Agent.LOG.severe("An error occurred parsing the connection information of HttpURLConnection : " + e.getMessage());
            host = "unknown";
            operation = "unknown";
        }
        return new HttpURLConnectionTracer(this, transaction, sig, connection, host, "HttpURLConnection", new String[]{operation});
    }

    private static final class HttpURLConnectionTracer
    extends ExternalComponentTracer
    implements IOTracer {
        private HttpURLConnectionTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String[] operations) {
            super(transaction, sig, object, host, library, operations);
        }

        protected void doFinish(int opcode, Object returnValue) {
            super.doFinish(opcode, returnValue);
            this.setResponseStatusCode((Integer)returnValue);
        }

        protected String getHeaderValue(Object returnValue, String name) {
            HttpURLConnection connection = (HttpURLConnection)this.getInvocationTarget();
            return connection.getHeaderField(name);
        }

        public TransactionSegment getTransactionSegment(ITransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
            if (lastSibling != null && lastSibling.getMetricName().equals(this.getTransactionSegmentName())) {
                lastSibling.merge(this);
                return lastSibling;
            }
            return super.getTransactionSegment(ttConfig, sqlObfuscator, startTime, lastSibling);
        }
    }
}

