/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.net.URLConnection;

public class URLConnectionPointCut
extends TracerFactoryPointCut {
    private static final String URL_CONNECTION_CLASS_NAME = "sun/net/www/protocol/http/HttpURLConnection";

    public URLConnectionPointCut(ClassTransformer classTransformer) {
        super(URLConnectionPointCut.class, (ClassMatcher)new ExactClassMatcher(URL_CONNECTION_CLASS_NAME), URLConnectionPointCut.createExactMethodMatcher("connect", "()V"));
        classTransformer.getClassNameFilter().addIncludeClass(URL_CONNECTION_CLASS_NAME);
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object urlConnection, Object[] args) {
        this.urlConnectionCreated(transaction, (URLConnection)urlConnection);
        return null;
    }

    protected void urlConnectionCreated(Transaction transaction, URLConnection urlConnection) {
    }
}

