/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.play;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.instrumentation.pointcuts.play.PlayDispatcherPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracerNoSkip;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import java.util.ArrayDeque;

public class PlayTransactionStateImpl
extends TransactionStateImpl {
    private static final Tracer NULL_TRACER = new MethodExitTracerNoSkip(null, null){

        protected void doFinish(int opcode, Object returnValue) {
        }
    };
    private final PlayDispatcherPointCut.PlayHttpRequest request;
    private State state = State.RUNNING;
    private ArrayDeque<Tracer> tracers = new ArrayDeque();
    private ArrayDeque<Tracer> suspendedTracers = new ArrayDeque();

    public PlayTransactionStateImpl(PlayDispatcherPointCut.PlayHttpRequest request) {
        this.request = request;
    }

    public Tracer getTracer(Transaction tx, TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
        Tracer tracer;
        if (this.state == State.RESUMING) {
            tracer = this.removeSuspendedTracer();
            if (tracer == NULL_TRACER) {
                return null;
            }
            if (tracer != null) {
                return tracer;
            }
            this.state = State.RUNNING;
        }
        this.addTracer((tracer = super.getTracer(tx, tracerFactory, signature, object, args)) == null ? NULL_TRACER : tracer);
        return tracer;
    }

    private Tracer removeSuspendedTracer() {
        return this.suspendedTracers.pollFirst();
    }

    private Tracer removeTracer() {
        return this.tracers.pollLast();
    }

    private void addTracer(Tracer tracer) {
        this.tracers.addLast(tracer);
    }

    public void resume() {
        this.state = State.RESUMING;
    }

    public void suspend() {
        this.state = State.SUSPENDING;
    }

    public void suspendRootTracer() {
        this.state = State.SUSPENDING_ROOT_TRACER;
    }

    public boolean finish(Transaction tx, Tracer tracer) {
        if (this.state == State.SUSPENDING) {
            if (tracer == tx.getRootTracer()) {
                this.saveTransaction(tx);
            }
            return false;
        }
        if (this.state == State.SUSPENDING_ROOT_TRACER && tracer == tx.getRootTracer()) {
            this.saveTransaction(tx);
            return false;
        }
        if (this.state == State.RESUMING) {
            this.suspendedTracers.clear();
            this.state = State.RUNNING;
        }
        while (this.removeTracer() == NULL_TRACER) {
        }
        return true;
    }

    private void saveTransaction(Transaction tx) {
        this.suspendedTracers = new ArrayDeque<Tracer>(this.tracers);
        this.request._nr_setTransaction(tx);
        Transaction.clearTransaction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RESUMING,
        RUNNING,
        SUSPENDING,
        SUSPENDING_ROOT_TRACER;

    }
}

