/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.ApplicationNamePriority;
import com.newrelic.agent.application.ApplicationNameUtils;
import com.newrelic.agent.application.HigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ErrorReportingTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.servlet.FilterExtension;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import com.newrelic.agent.util.EnvironmentUtils;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

@PointCut
public class ServletFilterPointCut
extends TracerFactoryPointCut {
    public static final String FILTER_CATEGORY = "Filter";
    private static final String SERVLET_FILTER_INTERFACE = "javax/servlet/Filter";
    public static final String INIT_METHOD_NAME = "init";
    public static final String INIT_METHOD_DESC = "(Ljavax/servlet/FilterConfig;)V";
    public static final String DESTROY_METHOD_NAME = "destroy";
    public static final String DESTROY_METHOD_DESC = "()V";
    public static final String DO_FILTER_METHOD_NAME = "doFilter";
    public static final String DO_FILTER_METHOD_DESC = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Ljavax/servlet/FilterChain;)V";
    private final Map<Object, Object> filterTofilterConfig = new ConcurrentHashMap<Object, Object>();

    public ServletFilterPointCut(ClassTransformer classTransformer) {
        super(ServletFilterPointCut.class, (ClassMatcher)new InterfaceMatcher(SERVLET_FILTER_INTERFACE), OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(INIT_METHOD_NAME, INIT_METHOD_DESC), new ExactMethodMatcher(DESTROY_METHOD_NAME, DESTROY_METHOD_DESC), new ExactMethodMatcher(DO_FILTER_METHOD_NAME, DO_FILTER_METHOD_DESC)));
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object filter, Object[] args) {
        try {
            if (DO_FILTER_METHOD_NAME == sig.getMethodName()) {
                this.setAppName(tx, sig, filter);
                this.setTransactionName(tx, sig, filter);
                return this.createTracer(tx, sig, filter, args);
            }
            if (INIT_METHOD_NAME == sig.getMethodName()) {
                this.storeFilterConfig(filter, args[0]);
                this.setServerInfo(args[0]);
            } else if (DESTROY_METHOD_NAME == sig.getMethodName()) {
                this.removeFilterConfig(filter);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", ServletFilterPointCut.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
        return null;
    }

    private Tracer createTracer(Transaction tx, ClassMethodSignature sig, Object filter, Object[] args) {
        ClassMethodMetricNameFormat format = new ClassMethodMetricNameFormat(sig, filter, FILTER_CATEGORY);
        return new ErrorReportingTracer(tx, sig, filter, format);
    }

    private void setAppName(Transaction tx, ClassMethodSignature sig, Object filter) {
        try {
            if (!tx.isAutoAppNamingEnabled()) {
                return;
            }
            this.doSetAppName(tx, filter);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception setting application name in {0} handling {1}: {2}", ServletFilterPointCut.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void doSetAppName(Transaction tx, Object filter) throws Exception {
        HigherPriorityApplicationNamingPolicy policy = HigherPriorityApplicationNamingPolicy.getInstance();
        if (!policy.canSetApplicationName(tx, ApplicationNamePriority.FILTER_INIT_PARAM)) {
            return;
        }
        Object filterConfig = this.getFilterConfig(filter);
        if (filterConfig != null) {
            ApplicationNameUtils.setAppNameForFilter(tx, filterConfig);
        }
    }

    private void setTransactionName(Transaction tx, ClassMethodSignature sig, Object filter) {
        try {
            if (!tx.isTransactionNamingEnabled()) {
                return;
            }
            this.doSetTransactionName(tx, filter);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception setting transaction name in {0} handling {1}: {2}", ServletFilterPointCut.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void doSetTransactionName(Transaction tx, Object filter) throws Exception {
        HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
        if (!policy.canSetTransactionName(tx, TransactionNamePriority.FILTER_INIT_PARAM)) {
            return;
        }
        Object filterConfig = this.getFilterConfig(filter);
        if (filterConfig == null) {
            return;
        }
        ServletService servletService = ServiceFactory.getServletService();
        String initParam = servletService.getInitParamForFilterConfig(filterConfig, "com.newrelic.agent.TRANSACTION_NAME");
        if (initParam != null && initParam.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using filter init parameter", initParam);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(tx, initParam, FILTER_CATEGORY, TransactionNamePriority.FILTER_INIT_PARAM);
            return;
        }
        if (policy.canSetTransactionName(tx, TransactionNamePriority.FILTER_NAME)) {
            String filterName = servletService.getFilterName(filterConfig);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using filter name", filterName);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(tx, filterName, FILTER_CATEGORY, TransactionNamePriority.FILTER_NAME);
        }
    }

    protected Object getFilterConfig(Object filter) {
        if (filter instanceof FilterExtension) {
            return ((FilterExtension)filter)._nr_getFilterConfig();
        }
        return this.filterTofilterConfig.get(filter);
    }

    private void removeFilterConfig(Object filter) {
        this.filterTofilterConfig.remove(filter);
    }

    private void storeFilterConfig(Object filter, Object filterConfig) throws Exception {
        if (filter instanceof FilterExtension) {
            return;
        }
        this.filterTofilterConfig.put(filter, filterConfig);
    }

    private void setServerInfo(Object filterConfig) throws Exception {
        ServletService servletService = ServiceFactory.getServletService();
        Object servletContext = servletService.getServletContextForFilterConfig(filterConfig);
        EnvironmentUtils.setServerInfo(servletContext);
    }
}

