/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.ApplicationNameUtils;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.tracers.WebRequestDispatcher;
import com.newrelic.agent.transaction.SameOrHigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class ServletRequestPointCut
extends PointCut
implements EntryInvocationHandler {
    public static final String REQUEST_ATTRIBUTE_CATEGORY = "RequestAttribute";
    static final ClassMatcher SERVLET_REQUEST_CLASS_MATCHER = OrClassMatcher.getClassMatcher(new ExactClassMatcher("org/apache/catalina/connector/Request"), new ExactClassMatcher("org/mortbay/jetty/servlet/ServletHttpRequest"), new ExactClassMatcher("org/eclipse/jetty/server/Request"), new ExactClassMatcher("javax/servlet/ServletRequestWrapper"), new ExactClassMatcher("org/apache/struts/mock/MockHttpServletRequest"), new InterfaceMatcher("javax/servlet/ServletRequest"));
    private final Map<String, ValueHandler> handlers = new IdentityHashMap<String, ValueHandler>(4){
        {
            this.put("com.newrelic.agent.IGNORE", new ValueHandler(){

                public void handle(Transaction transaction, Object value) {
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        transaction.setIgnore(true);
                    }
                }
            });
            this.put("com.newrelic.agent.IGNORE_APDEX", new ValueHandler(){

                public void handle(Transaction transaction, Object value) {
                    Dispatcher dispatcher = transaction.getDispatcher();
                    if (dispatcher instanceof WebRequestDispatcher) {
                        ((WebRequestDispatcher)dispatcher).setIgnoreApdex(value instanceof Boolean && (Boolean)value != false);
                    }
                }
            });
            this.put("com.newrelic.agent.APPLICATION_NAME", new ValueHandler(){

                public void handle(Transaction transaction, Object value) {
                    ApplicationNameUtils.setAppNameForRequestAttribute((String)value, transaction);
                }
            });
            this.put("com.newrelic.agent.TRANSACTION_NAME", new ValueHandler(){

                public void handle(Transaction transaction, Object value) {
                    if (Agent.LOG.isLoggable(Level.FINER)) {
                        String msg = MessageFormat.format("Setting transaction name to \"{0}\" using request attribute", (String)value);
                        Agent.LOG.finer(msg);
                    }
                    SameOrHigherPriorityTransactionNamingPolicy policy = SameOrHigherPriorityTransactionNamingPolicy.getInstance();
                    policy.setTransactionName(transaction, (String)value, ServletRequestPointCut.REQUEST_ATTRIBUTE_CATEGORY, TransactionNamePriority.REQUEST_ATTRIBUTE);
                }
            });
        }
    };

    public ServletRequestPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(ServletRequestPointCut.class), SERVLET_REQUEST_CLASS_MATCHER, ServletRequestPointCut.createExactMethodMatcher("setAttribute", "(Ljava/lang/String;Ljava/lang/Object;)V"));
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        String attributeName = (String)args[0];
        Object value = args[1];
        ValueHandler valueHandler = this.handlers.get(attributeName);
        if (valueHandler != null) {
            valueHandler.handle(Transaction.getTransaction(), value);
        }
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    private static interface ValueHandler {
        public void handle(Transaction var1, Object var2);
    }
}

