/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.AsyncContextTracer;

@PointCut
public class ServletRequestStartAsyncPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = ServletRequestStartAsyncPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String SERVLET_REQUEST_INTERFACE = "javax/servlet/ServletRequest";
    private static final String HTTP_SERVLET_REQUEST_INTERFACE = "javax/servlet/HttpServletRequest";
    private static final String RESIN_ASYNC_REQUEST_CLASS = "com/caucho/server/webapp/AsyncRequest";
    private static final String START_ASYNC_METHOD_NAME = "startAsync";
    private static final String START_ASYNC_METHOD_DESC_1 = "()Ljavax/servlet/AsyncContext;";
    private static final String START_ASYNC_METHOD_DESC_2 = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)Ljavax/servlet/AsyncContext;";
    private static final MetricNameFormat START_ASYNC_FORMAT = new SimpleMetricNameFormat("ServletRequest.startAsync");

    public ServletRequestStartAsyncPointCut(ClassTransformer ct) {
        super(ServletRequestStartAsyncPointCut.createPointCutConfig(), ServletRequestStartAsyncPointCut.createClassMatcher(), ServletRequestStartAsyncPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, null, true);
    }

    private static ClassMatcher createClassMatcher() {
        return OrClassMatcher.getClassMatcher(new ExactClassMatcher(RESIN_ASYNC_REQUEST_CLASS), new InterfaceMatcher(SERVLET_REQUEST_INTERFACE), new InterfaceMatcher(HTTP_SERVLET_REQUEST_INTERFACE));
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(START_ASYNC_METHOD_NAME, START_ASYNC_METHOD_DESC_1, START_ASYNC_METHOD_DESC_2);
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object obj, Object[] args) {
        if (tx.getLastTracer() instanceof AsyncContextTracer) {
            return null;
        }
        return new AsyncContextTracer(tx, sig, obj, START_ASYNC_FORMAT);
    }
}

