/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.solr;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.solr.AbstractSolrPointCut;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.IgnoreChildSocketCalls;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@PointCut
public class SolrServerPointCut
extends AbstractSolrPointCut {
    private static final String QUERY_METHOD_NAME = "query";
    private static final String NO_ARG_DESCRIPTION = "()Lorg/apache/solr/client/solrj/response/UpdateResponse;";

    public SolrServerPointCut(ClassTransformer classTransformer) {
        super((Class<? extends AbstractSolrPointCut>)SolrServerPointCut.class, (ClassMatcher)new ExactClassMatcher("org/apache/solr/client/solrj/SolrServer"), OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("add", "(Ljava/util/Collection;)Lorg/apache/solr/client/solrj/response/UpdateResponse;", "(Lorg/apache/solr/common/SolrInputDocument;)Lorg/apache/solr/client/solrj/response/UpdateResponse;"), new ExactMethodMatcher("commit", NO_ARG_DESCRIPTION, "(ZZ)Lorg/apache/solr/client/solrj/response/UpdateResponse;"), new ExactMethodMatcher("optimize", NO_ARG_DESCRIPTION, "(ZZ)Lorg/apache/solr/client/solrj/response/UpdateResponse;", "(ZZI)Lorg/apache/solr/client/solrj/response/UpdateResponse;"), new ExactMethodMatcher("rollback", NO_ARG_DESCRIPTION), new ExactMethodMatcher("deleteById", "(Ljava/lang/String;)Lorg/apache/solr/client/solrj/response/UpdateResponse;", "(Ljava/util/List;)Lorg/apache/solr/client/solrj/response/UpdateResponse;"), new ExactMethodMatcher("deleteByQuery", "(Ljava/lang/String;)Lorg/apache/solr/client/solrj/response/UpdateResponse;"), new ExactMethodMatcher("ping", "()Lorg/apache/solr/client/solrj/response/SolrPingResponse;"), new ExactMethodMatcher(QUERY_METHOD_NAME, "(Lorg/apache/solr/common/params/SolrParams;)Lorg/apache/solr/client/solrj/response/QueryResponse;", "(Lorg/apache/solr/common/params/SolrParams;Lorg/apache/solr/client/solrj/SolrRequest$METHOD;)Lorg/apache/solr/client/solrj/response/QueryResponse;")));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object server, Object[] args) {
        return new SolrServerTracer(transaction, sig, server, args);
    }

    private class SolrServerTracer
    extends DefaultTracer
    implements IgnoreChildSocketCalls {
        public SolrServerTracer(Transaction transaction, ClassMethodSignature sig, Object server, Object[] args) {
            super(transaction, sig, server, new ClassMethodMetricNameFormat(sig, server, "SolrClient"));
            if (SolrServerPointCut.QUERY_METHOD_NAME.equals(sig.getMethodName())) {
                Object solrParams = args[0];
                Class<?> paramsClass = solrParams.getClass();
                try {
                    Method paramNamesIter = paramsClass.getMethod("getParameterNamesIterator", new Class[0]);
                    Method getParams = paramsClass.getMethod("getParams", String.class);
                    HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
                    Iterator iter = (Iterator)paramNamesIter.invoke(solrParams, new Object[0]);
                    while (iter.hasNext()) {
                        String name = (String)iter.next();
                        String[] values = (String[])getParams.invoke(solrParams, name);
                        paramMap.put(name, values);
                    }
                    if (!paramMap.isEmpty()) {
                        ServletService servletService = ServiceFactory.getServletService();
                        this.put("query_params", servletService.getSimpleParameterMap(paramMap));
                    }
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Solr client error", e);
                }
            }
        }

        protected void doRecordMetrics(TransactionStats transactionStats) {
            transactionStats.getUnscopedStats().getResponseTimeStats("Solr/all").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            transactionStats.getUnscopedStats().getResponseTimeStats((this.transaction.isWebTransaction() ? MetricName.WEB_TRANSACTION_SOLR_ALL : MetricName.OTHER_TRANSACTION_SOLR_ALL).getName()).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        }
    }
}

